/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n;

import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import org.tentackle.i18n.BundleEnumeration;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;

public class StoredResourceBundle
extends ResourceBundle {
    private final Properties props = new Properties();
    private final String name;

    public StoredResourceBundle(StoredBundle bundle) {
        this.name = bundle.toString();
        for (StoredBundleKey bundleKey : bundle.getKeys()) {
            this.props.setProperty(bundleKey.getKey(), bundleKey.getValue());
        }
    }

    void setParent(StoredResourceBundle parent) {
        super.setParent(parent);
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        return this.props.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle p = this.parent;
        return new BundleEnumeration(this.props.stringPropertyNames(), p != null ? p.getKeys() : null);
    }

    public String toString() {
        return this.name;
    }
}

