/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class BundleEnumeration
implements Enumeration<String> {
    private final Set<String> keys;
    private final Iterator<String> iterator;
    private final Enumeration<String> parentEnumeration;
    private String next = null;

    public BundleEnumeration(Set<String> keys, Enumeration<String> parentEnumeration) {
        this.keys = keys;
        this.iterator = keys.iterator();
        this.parentEnumeration = parentEnumeration;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.next == null) {
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
            } else if (this.parentEnumeration != null) {
                while (this.next == null && this.parentEnumeration.hasMoreElements()) {
                    this.next = this.parentEnumeration.nextElement();
                    if (!this.keys.contains(this.next)) continue;
                    this.next = null;
                }
            }
        }
        return this.next != null;
    }

    @Override
    public String nextElement() {
        if (this.hasMoreElements()) {
            String result = this.next;
            this.next = null;
            return result;
        }
        throw new NoSuchElementException();
    }
}

