/*
 * Tentackle - https://tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.i18n.pdo;

import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.i18n.pdo.rmi.StoredBundleKeyRemoteDelegate;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.sql.Backend;

import java.io.Serial;
import java.rmi.RemoteException;
import java.util.Objects;



/**
 * Number Space persistence implementation.
 *
 * @author harald
 */
@PersistentObjectService(StoredBundleKey.class)
public class StoredBundleKeyPersistenceImpl extends AbstractPersistentObject<StoredBundleKey, StoredBundleKeyPersistenceImpl> implements StoredBundleKeyPersistence {

  @Serial
  private static final long serialVersionUID = 1L;


  // @wurblet classVariables ClassVariables

  //<editor-fold defaultstate="collapsed" desc="code 'classVariables' generated by wurblet ClassVariables">//GEN-BEGIN:classVariables

  /** Variables common to all instances of StoredBundleKeyPersistenceImpl. */
  public static final PersistentObjectClassVariables<StoredBundleKey, StoredBundleKeyPersistenceImpl> CLASSVARIABLES =
            PersistentObjectClassVariables.create(
                    StoredBundleKey.class,
                    StoredBundleKeyPersistenceImpl.class,
                    "bkey",
                    null,
                    null);

  @Override
  public PersistentObjectClassVariables<StoredBundleKey, StoredBundleKeyPersistenceImpl> getClassVariables() {
    return CLASSVARIABLES;
  }

  //</editor-fold>//GEN-END:classVariables

  // @wurblet fieldnames ColumnNames

  //<editor-fold defaultstate="collapsed" desc="code 'fieldnames' generated by wurblet ColumnNames">//GEN-BEGIN:fieldnames


  /** database column name for 'bundleId'. */
  public static final String CN_BUNDLEID = "bundle_id";

  /** database column name for 'key'. */
  public static final String CN_KEY = "bkey";

  /** database column name for 'value'. */
  public static final String CN_VALUE = "bvalue";

  //</editor-fold>//GEN-END:fieldnames

  // @wurblet declare Declare

  //<editor-fold defaultstate="collapsed" desc="code 'declare' generated by wurblet Declare">//GEN-BEGIN:declare


  /** the bundle id. */
  private long bundleId;

  /** the resource bundle key. */
  private String key;

  /** the localized string. */
  private String value;

  //</editor-fold>//GEN-END:declare


  /**
   * Creates a number space.
   *
   * @param pdo the number space PDO
   * @param context the domain context
   */
  public StoredBundleKeyPersistenceImpl (StoredBundleKey pdo, DomainContext context)    {
    super(pdo, context);
  }

  /**
   * Creates a number space with a session only.
   *
   * @param pdo the number space PDO
   * @param session the session
   */
  public StoredBundleKeyPersistenceImpl(StoredBundleKey pdo, Session session) {
    super(pdo, session);
  }

  /**
   * Creates a number space without domain context or session.
   *
   * @param pdo the number space PDO
   */
  public StoredBundleKeyPersistenceImpl(StoredBundleKey pdo) {
    super(pdo);
  }

  /**
   * Creates a number space without domain context or session.
   */
  public StoredBundleKeyPersistenceImpl() {
    super();
  }


  // @wurblet methods MethodsImpl

  //<editor-fold defaultstate="collapsed" desc="code 'methods' generated by wurblet MethodsImpl">//GEN-BEGIN:methods


  @Override
  public StoredBundleKeyRemoteDelegate getRemoteDelegate() {
    return (StoredBundleKeyRemoteDelegate) super.getRemoteDelegate();
  }

  @Override
  public long getRootId() {
    return bundleId;
  }

  @Override
  public int getRootClassId() {
    return 8;
  }

  @Override
  public boolean isTracked() {
    return true;    // invoking isModified() is ok
  }

  @Override
  public void getFields(ResultSetWrapper rs) {
    super.getFields(rs);
    if (rs.configureSection(CLASSVARIABLES)) {
      rs.configureColumn(CN_BUNDLEID);
      rs.configureColumn(CN_KEY);
      rs.configureColumn(CN_VALUE);
      rs.configureColumn(CN_ID);
      rs.configureColumn(CN_SERIAL);
    }
    if (rs.getRow() <= 0) {
      throw new PersistenceException(getSession(), "no valid row");
    }
    bundleId = rs.getLong();
    key = rs.getString();
    value = rs.getString();
    setId(rs.getLong());
    setSerial(rs.getLong());
  }

  @Override
  public int setFields(PreparedStatementWrapper st) {
    int ndx = super.setFields(st);
    st.setLong(++ndx, bundleId);
    st.setString(++ndx, key);
    st.setString(++ndx, value);
    st.setLong(++ndx, getId());
    st.setLong(++ndx, getSerial());
    return ndx;
  }

  @Override
  public String createInsertSql() {
    return Backend.SQL_INSERT_INTO + getTableName() + Backend.SQL_LEFT_PARENTHESIS +
           CN_BUNDLEID + Backend.SQL_COMMA +
           CN_KEY + Backend.SQL_COMMA +
           CN_VALUE + Backend.SQL_COMMA +
           CN_ID + Backend.SQL_COMMA +
           CN_SERIAL +
           Backend.SQL_INSERT_VALUES +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR + Backend.SQL_RIGHT_PARENTHESIS;
  }

  @Override
  public String createUpdateSql() {
    return Backend.SQL_UPDATE + getTableName() + Backend.SQL_SET +
           CN_BUNDLEID + Backend.SQL_EQUAL_PAR_COMMA +
           CN_KEY + Backend.SQL_EQUAL_PAR_COMMA +
           CN_VALUE + Backend.SQL_EQUAL_PAR_COMMA +
           CN_SERIAL + Backend.SQL_EQUAL + CN_SERIAL + Backend.SQL_PLUS_ONE +
           Backend.SQL_WHERE + CN_ID + Backend.SQL_EQUAL_PAR +
           Backend.SQL_AND + CN_SERIAL + Backend.SQL_EQUAL_PAR;
  }

  @Override
  public long getBundleId()    {
    return bundleId;
  }

  /**
   * Sets the attribute bundleId.
   *
   * @param bundleId the bundle id
   */
  private void setBundleId(long bundleId) {
    if (this.bundleId != bundleId) {
      setModified(true);
      this.bundleId = bundleId;
    }
  }

  @Override
  public String getKey()    {
    return key;
  }

  @Override
  public void setKey(String key) {
    if (!Objects.equals(this.key, key)) {
      setModified(true);
      this.key = key;
    }
  }

  @Override
  public String getValue()    {
    return value;
  }

  @Override
  public void setValue(String value) {
    if (!Objects.equals(this.value, value)) {
      setModified(true);
      this.value = value;
    }
  }

  /**
   * Copies all attributes from a snapshot back to this object.
   *
   * @param snapshot the snapshot object
   */
  protected void revertAttributesToSnapshot(StoredBundleKeyPersistenceImpl snapshot) {
    super.revertAttributesToSnapshot(snapshot);
    bundleId = snapshot.bundleId;
    key = snapshot.key;
    value = snapshot.value;
  }

  //</editor-fold>//GEN-END:methods

  // @wurblet relations PdoRelations

  //<editor-fold defaultstate="collapsed" desc="code 'relations' generated by wurblet PdoRelations">//GEN-BEGIN:relations


  // StoredBundle bundle via bundleId (Bundle)
  private StoredBundle bundle;
  private boolean bundleLoaded;

  @Override
  public StoredBundle getBundle()  {
    if (!bundleLoaded) {
      bundle = bundleId == 0 ? null : on(StoredBundle.class).select(bundleId);
      bundleLoaded = true;
    }
    return bundle;
  }

  /**
   * Gets bundle without performing a select if not loaded.
   *
   * @return bundle Bundle
   */
  public StoredBundle getBundleBlunt() {
    return bundle;
  }

  @Override
  public void setBundle(StoredBundle bundle)  {
    this.bundle = bundle;
    setBundleId(bundle == null ? 0 : bundle.getId());
    bundleLoaded = true;
  }

  /**
   * Sets bundle without setting any attributes.
   *
   * @param bundle Bundle
   */
  public void setBundleBlunt(StoredBundle bundle) {
    this.bundle = bundle;
    bundleLoaded = true;
  }

  @Override
  public void setSession(Session session)  {
    super.setSession(session);
    session.applyTo(bundle);
  }

  @Override
  public void setDomainContext(DomainContext context)  {
    super.setDomainContext(context);
    context.applyTo(bundle);
  }

  // selects composite list of StoredBundleKey keys via StoredBundleKey#bundleId (Keys)
  // @wurblet selectByBundleId PdoSelectList --tracked bundleId

  //</editor-fold>//GEN-END:relations

  //<editor-fold defaultstate="collapsed" desc="code 'selectByBundleId' generated by wurblet PdoSelectList/PdoRelations">//GEN-BEGIN:selectByBundleId


  private static final StatementId SELECT_BY_BUNDLE_ID_STMT = new StatementId();

  @Override
  public TrackedList<StoredBundleKey> selectByBundleId(long bundleId) {
    if (getSession().isRemote())  {
      try {
        TrackedList<StoredBundleKey> list = getRemoteDelegate().selectByBundleId(getDomainContext(), bundleId);
        configureRemoteObjects(getDomainContext(), list);
        return list;
      }
      catch (RemoteException e) {
        throw PersistenceException.createFromRemoteException(this, e);
      }
    }
    PreparedStatementWrapper st = getPreparedStatement(SELECT_BY_BUNDLE_ID_STMT,
      () -> {
        StringBuilder sql = createSelectAllInnerSql();
        sql.append(Backend.SQL_AND);
        sql.append(getColumnName(CN_BUNDLEID));
        sql.append(Backend.SQL_EQUAL_PAR);
        getBackend().buildSelectSql(sql, false, 0, 0);
        return sql.toString();
      }
    );
    int ndx = 1;
    st.setLong(ndx, bundleId);
    return executeTrackedListQuery(st);
  }

  //</editor-fold>//GEN-END:selectByBundleId


}

