/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.BundleFactory;
import org.tentackle.common.BundleSupport;
import org.tentackle.common.DefaultBundleFactory;
import org.tentackle.common.Service;
import org.tentackle.i18n.StoredBundleControl;
import org.tentackle.i18n.StoredResourceBundle;
import org.tentackle.i18n.pdo.StoredBundle;

@Service(value=BundleFactory.class)
public class StoredBundleFactory
extends DefaultBundleFactory {
    private static boolean enabled = true;
    private final Map<StoredBundle.StoredBundleUDK, ResourceBundle> bundleMap = new ConcurrentHashMap<StoredBundle.StoredBundleUDK, ResourceBundle>();
    private final StoredBundleControl control = new StoredBundleControl();

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        StoredBundleFactory.enabled = enabled;
    }

    public void clearCache() {
        super.clearCache();
        this.bundleMap.clear();
    }

    protected ResourceBundle getBundle(BundleSupport support, Locale locale) {
        if (enabled) {
            StoredBundle.StoredBundleUDK topKey = this.control.createUDK(support.getBundleName(), locale);
            return this.bundleMap.computeIfAbsent(topKey, storedBundleUDK -> {
                StoredResourceBundle parentBundle;
                StoredBundle.StoredBundleUDK key = storedBundleUDK;
                StoredResourceBundle bundle = this.control.loadStoredBundle(key);
                while (bundle == null && (key = this.createParentKey(key)) != null) {
                    bundle = this.control.loadStoredBundle(key);
                }
                if (bundle == null) {
                    return super.getBundle(support, locale);
                }
                StoredResourceBundle currentBundle = bundle;
                while ((key = this.createParentKey(key)) != null && (parentBundle = this.control.loadStoredBundle(key)) != null) {
                    currentBundle.setParent(parentBundle);
                    currentBundle = parentBundle;
                }
                return bundle;
            });
        }
        return super.getBundle(support, locale);
    }

    private StoredBundle.StoredBundleUDK createParentKey(StoredBundle.StoredBundleUDK key) {
        StoredBundle.StoredBundleUDK parentKey = null;
        if (key.locale() != null && !key.locale().isEmpty()) {
            int ndx = key.locale().lastIndexOf(95);
            String parentLocaleName = ndx > 0 ? key.locale().substring(0, ndx) : null;
            parentKey = new StoredBundle.StoredBundleUDK(key.name(), parentLocaleName);
        }
        return parentKey;
    }
}

