/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n.pdo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tentackle.domain.AbstractDomainObject;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleDomain;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.pdo.DomainObjectService;
import org.tentackle.pdo.PersistentDomainObject;

@DomainObjectService(value=StoredBundle.class)
public class StoredBundleDomainImpl
extends AbstractDomainObject<StoredBundle, StoredBundleDomainImpl>
implements StoredBundleDomain {
    private static final long serialVersionUID = 1L;
    private transient Map<String, String> translations;

    public StoredBundleDomainImpl(StoredBundle pdo) {
        super((PersistentDomainObject)pdo);
    }

    public StoredBundleDomainImpl() {
    }

    public boolean isUniqueDomainKeyProvided() {
        return true;
    }

    public Class<?> getUniqueDomainKeyType() {
        return StoredBundle.StoredBundleUDK.class;
    }

    public StoredBundle findByUniqueDomainKey(Object domainKey) {
        StoredBundle.StoredBundleUDK udk = (StoredBundle.StoredBundleUDK)domainKey;
        return ((StoredBundle)this.on()).selectByUniqueDomainKey(udk.name(), udk.locale());
    }

    @Override
    public StoredBundle.StoredBundleUDK getUniqueDomainKey() {
        return new StoredBundle.StoredBundleUDK((StoredBundle)this.me());
    }

    public void setUniqueDomainKey(Object domainKey) {
        StoredBundle.StoredBundleUDK udk = (StoredBundle.StoredBundleUDK)domainKey;
        ((StoredBundle)this.me()).setName(udk.name());
        ((StoredBundle)this.me()).setLocale(udk.locale());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((StoredBundle)this.me()).getName());
        String locale = ((StoredBundle)this.me()).getLocale();
        if (locale != null) {
            buf.append('_').append(locale);
        }
        return buf.toString();
    }

    @Override
    public synchronized String getTranslation(String key) {
        if (this.translations == null) {
            this.translations = new HashMap<String, String>();
            for (StoredBundleKey bundleKey : ((StoredBundle)this.me()).getKeys()) {
                this.translations.put(bundleKey.getKey(), bundleKey.getValue());
            }
        }
        return this.translations.get(key);
    }

    @Override
    public synchronized void setTranslation(String key, String value) {
        this.translations = null;
        Iterator iter = ((StoredBundle)this.me()).getKeys().iterator();
        while (iter.hasNext()) {
            StoredBundleKey bundleKey = (StoredBundleKey)iter.next();
            if (!key.equals(bundleKey.getKey())) continue;
            if (value == null) {
                iter.remove();
            } else {
                bundleKey.setValue(value);
            }
            return;
        }
        if (value != null) {
            StoredBundleKey bundleKey = (StoredBundleKey)this.on(StoredBundleKey.class);
            bundleKey.setKey(key);
            bundleKey.setValue(value);
            ((StoredBundle)this.me()).getKeys().add((Object)bundleKey);
        }
    }
}

