/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n.pdo;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.i18n.pdo.StoredBundleKeyPersistenceImpl;
import org.tentackle.i18n.pdo.StoredBundlePersistence;
import org.tentackle.i18n.pdo.rmi.StoredBundleRemoteDelegate;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoCacheIndex;
import org.tentackle.pdo.PdoListener;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.Join;
import org.tentackle.persist.JoinedSelect;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.session.ModificationEvent;
import org.tentackle.session.ModificationListener;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Persistent;
import org.tentackle.session.Session;
import org.tentackle.sql.JoinType;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilities;

@PersistentObjectService(value=StoredBundle.class)
public class StoredBundlePersistenceImpl
extends AbstractPersistentObject<StoredBundle, StoredBundlePersistenceImpl>
implements StoredBundlePersistence {
    private static final long serialVersionUID = -1178587730540795339L;
    public static final PersistentObjectClassVariables<StoredBundle, StoredBundlePersistenceImpl> CLASSVARIABLES = new PersistentObjectClassVariables(StoredBundle.class, StoredBundlePersistenceImpl.class, "bndl", null, Arrays.asList(new Join(JoinType.LEFT, "bndl.id", "e_1.bundle_id", StoredBundleKey.class, "e_1", (bndl, bkey) -> {
        ((StoredBundlePersistenceImpl)bndl.getPersistenceDelegate()).getKeysBlunt().addBlunt(bkey);
        ((StoredBundleKeyPersistenceImpl)bkey.getPersistenceDelegate()).setBundleBlunt((StoredBundle)bndl);
    })));
    public static final String CN_NAME = "bname";
    public static final String CN_LOCALE = "blocale";
    @Persistent(value="the resource bundle name")
    private String name;
    @Persistent(value="the locale, null if default")
    private String locale;
    private static final StatementId SELECT_BY_UNIQUE_DOMAIN_KEY_STMT = new StatementId();
    @Persistent(value="Keys")
    private TrackedList<StoredBundleKey> keys;
    private boolean keysLoaded;
    private transient TrackedList<StoredBundleKey> keysSnapshot;
    private static PdoCache<StoredBundle> cache;
    private static PdoCacheIndex<StoredBundle, StoredBundle.StoredBundleUDK> udkIndex;
    private static final StatementId FIND_BY_NAME_STMT;
    private static final StatementId FIND_BY_NAME_AND_LOCALE_STMT;

    public PersistentObjectClassVariables<StoredBundle, StoredBundlePersistenceImpl> getClassVariables() {
        return CLASSVARIABLES;
    }

    public StoredBundlePersistenceImpl(StoredBundle pdo, DomainContext context) {
        super((PersistentDomainObject)pdo, context);
    }

    public StoredBundlePersistenceImpl(StoredBundle pdo, Session session) {
        super((PersistentDomainObject)pdo, session);
    }

    public StoredBundlePersistenceImpl(StoredBundle pdo) {
        super((PersistentDomainObject)pdo);
    }

    public StoredBundlePersistenceImpl() {
    }

    public StoredBundleRemoteDelegate getRemoteDelegate() {
        return (StoredBundleRemoteDelegate)super.getRemoteDelegate();
    }

    public boolean isRootEntity() {
        return true;
    }

    public boolean isTableSerialProvided() {
        return true;
    }

    public boolean isTracked() {
        return true;
    }

    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn("tableserial");
            rs.configureColumn(CN_NAME);
            rs.configureColumn(CN_LOCALE);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.setTableSerial(rs.getLong());
        this.name = rs.getString();
        this.locale = rs.getString(true);
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setLong(++ndx, this.getTableSerial());
        st.setString(++ndx, this.name);
        st.setString(++ndx, this.locale, true);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + "tableserial" + "," + CN_NAME + "," + CN_LOCALE + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + "tableserial" + "=?," + CN_NAME + "=?," + CN_LOCALE + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.assertMutable();
        if (!Objects.equals(this.name, name)) {
            this.setModified(true);
        }
        this.name = name;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String locale) {
        this.assertMutable();
        if (!Objects.equals(this.locale, locale)) {
            this.setModified(true);
        }
        this.locale = locale;
    }

    protected void createAttributesInSnapshot(StoredBundlePersistenceImpl snapshot) {
        super.createAttributesInSnapshot((AbstractPersistentObject)snapshot);
    }

    protected void revertAttributesToSnapshot(StoredBundlePersistenceImpl snapshot) {
        super.revertAttributesToSnapshot((AbstractPersistentObject)snapshot);
        this.name = snapshot.name;
        this.locale = snapshot.locale;
    }

    @Override
    public StoredBundle selectByUniqueDomainKey(String name, String locale) {
        if (this.getSession().isRemote()) {
            try {
                StoredBundle obj = this.getRemoteDelegate().selectByUniqueDomainKey(this.getDomainContext(), name, locale);
                this.configureRemoteObject(this.getDomainContext(), obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_UNIQUE_DOMAIN_KEY_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_LOCALE));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, name);
        st.setString(ndx++, locale, true);
        return (StoredBundle)this.executeFirstPdoQuery(st);
    }

    @Override
    public TrackedList<StoredBundleKey> getKeys() {
        if (!this.keysLoaded) {
            this.keys = this.isNew() ? new TrackedArrayList(false) : ((StoredBundleKey)this.on(StoredBundleKey.class)).selectByBundleId(this.getId());
            for (StoredBundleKey obj : this.keys) {
                obj.setBundle((StoredBundle)this.pdo());
            }
            if (this.isImmutable()) {
                this.keys.setImmutable(true);
            }
            this.keysLoaded = true;
        }
        return this.keys;
    }

    public TrackedList<StoredBundleKey> getKeysBlunt() {
        if (!this.keysLoaded) {
            this.keys = new TrackedArrayList(false);
            if (this.isImmutable()) {
                this.keys.setImmutable(true);
            }
            this.keysLoaded = true;
        }
        return this.keys;
    }

    @Override
    public boolean isKeysLoaded() {
        return this.keysLoaded;
    }

    public void setSession(Session session) {
        super.setSession(session);
        session.applyTo(this.keys);
    }

    public void setDomainContext(DomainContext context) {
        super.setDomainContext(context);
        context.applyTo(this.keys);
    }

    public void deleteRemovedReferencingRelations() {
        if (this.keys != null && this.keys.isSomeRemoved()) {
            this.delete(this.keys.getRemovedObjects());
        }
    }

    public void saveReferencingRelations(boolean update) {
        super.saveReferencingRelations(update);
        if (update) {
            this.deleteRemovedReferencingRelations();
        }
        if (this.keys != null) {
            this.getDomainContext().applyTo(this.keys);
            for (StoredBundleKey obj : this.keys) {
                obj.setBundle((StoredBundle)this.pdo());
            }
            this.save((Collection)this.keys, true);
        }
    }

    public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
        List results = super.validate(validationPath, scope);
        if (this.keys != null) {
            results.addAll(ValidationUtilities.getInstance().validateCollection(this.keys, validationPath + ".keys", scope));
        }
        return results;
    }

    public void setImmutable(boolean immutable) {
        super.setImmutable(immutable);
        if (this.keys != null) {
            this.keys.setImmutable(immutable);
        }
    }

    public boolean isModified() {
        return super.isModified() || this.isModified((Collection)this.keys);
    }

    public boolean isComposite() {
        return true;
    }

    public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
        IdentifiableMap components = new IdentifiableMap();
        this.addComponents(components, onlyLoaded);
        return components;
    }

    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, boolean onlyLoaded) {
        int count = 0;
        count += super.addComponents(components, onlyLoaded);
        if (!onlyLoaded || this.keysLoaded) {
            count += this.addComponents((IdentifiableMap)components, (Collection)this.getKeys(), onlyLoaded);
        }
        return count;
    }

    public void insertPlainWithComponents() {
        this.insertPlain();
        this.insertPlainWithComponents((Collection)this.getKeys());
    }

    public void deletePlainWithComponents() {
        this.deletePlain();
    }

    public void markDeleted() {
        super.markDeleted();
        this.markDeleted((Collection)this.keys);
    }

    protected void createComponentsInSnapshot(StoredBundlePersistenceImpl snapshot) {
        super.createComponentsInSnapshot((AbstractPersistentObject)snapshot);
        if (this.keys != null) {
            snapshot.keysSnapshot = (TrackedList)this.keys.createSnapshot();
        }
    }

    protected void revertComponentsToSnapshot(StoredBundlePersistenceImpl snapshot) {
        super.revertComponentsToSnapshot((AbstractPersistentObject)snapshot);
        this.keys = snapshot.keys;
        if (this.keys != null) {
            this.keys.revertToSnapshot(snapshot.keysSnapshot);
        }
        this.keysLoaded = snapshot.keysLoaded;
    }

    private static synchronized PdoCache<StoredBundle> createCache() {
        if (cache == null) {
            cache = Pdo.createPdoCache(StoredBundle.class, (boolean)false, (boolean)true, (boolean)false);
            udkIndex = new PdoCacheIndex<StoredBundle, StoredBundle.StoredBundleUDK>("StoredBundle:UDK"){

                public StoredBundle select(DomainContext context, StoredBundle.StoredBundleUDK udk) {
                    return ((StoredBundle)Pdo.create(StoredBundle.class, (DomainContext)context)).findByUniqueDomainKeyForCache(udk);
                }

                public StoredBundle.StoredBundleUDK extract(StoredBundle pdo) {
                    return pdo.getUniqueDomainKey();
                }
            };
            ModificationTracker.getInstance().addModificationListener((ModificationListener)new PdoListener(new Class[]{StoredBundle.class}){

                public void dataChanged(ModificationEvent ev) {
                    cache.expire(ev.getSerial());
                }
            });
        }
        return cache;
    }

    public PdoCache<StoredBundle> getCache() {
        return cache == null ? StoredBundlePersistenceImpl.createCache() : cache;
    }

    public boolean isCountingModification(char modType) {
        return true;
    }

    public boolean isReadAllowed() {
        return true;
    }

    public boolean expireCache(long maxSerial) {
        this.getCache().expire(maxSerial);
        return true;
    }

    public StoredBundle selectCachedOnly(long id) {
        return (StoredBundle)this.getCache().select(this.getDomainContext(), id, false);
    }

    public StoredBundle selectCached(long id) {
        return (StoredBundle)this.getCache().select(this.getDomainContext(), id);
    }

    @Override
    public StoredBundle selectCachedOnlyByUniqueDomainKey(StoredBundle.StoredBundleUDK udk) {
        return (StoredBundle)this.getCache().select(udkIndex, this.getDomainContext(), (Comparable)udk, false);
    }

    @Override
    public StoredBundle selectCachedByUniqueDomainKey(StoredBundle.StoredBundleUDK udk) {
        return (StoredBundle)this.getCache().select(udkIndex, this.getDomainContext(), (Comparable)udk);
    }

    @Override
    public StoredBundle findByUniqueDomainKeyForCache(StoredBundle.StoredBundleUDK udk) {
        StoredBundle obj;
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                obj = this.getRemoteDelegate().selectByUniqueDomainKeyForCache(context, udk);
                this.configureRemoteObject(context, obj);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            obj = (StoredBundle)((StoredBundle)this.pdo()).findByUniqueDomainKey(udk);
        }
        return obj;
    }

    @Override
    public TrackedList<StoredBundle> findByName(String name) {
        if (this.getSession().isRemote()) {
            try {
                TrackedList<StoredBundle> list = this.getRemoteDelegate().findByName(this.getDomainContext(), name);
                this.configureRemoteObjects(this.getDomainContext(), (Collection)list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect js = new JoinedSelect().addJoin(new Join(JoinType.LEFT, this.getColumnName("id"), "j_1.bundle_id", StoredBundleKey.class, "j_1", (bndl, bkey) -> {
            ((StoredBundlePersistenceImpl)bndl.getPersistenceDelegate()).getKeysBlunt().addBlunt(bkey);
            ((StoredBundleKeyPersistenceImpl)bkey.getPersistenceDelegate()).setBundleBlunt((StoredBundle)bndl);
        }));
        PreparedStatementWrapper st = this.getPreparedStatement(FIND_BY_NAME_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            js.createJoinedSql(this.pdo(), sql);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, name);
        return this.executeTrackedListQuery(st, js);
    }

    @Override
    public StoredBundle findByNameAndLocale(String name, String locale) {
        if (this.getSession().isRemote()) {
            try {
                StoredBundle obj = this.getRemoteDelegate().findByNameAndLocale(this.getDomainContext(), name, locale);
                this.configureRemoteObject(this.getDomainContext(), obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect js = new JoinedSelect().addJoin(new Join(JoinType.LEFT, this.getColumnName("id"), "j_1.bundle_id", StoredBundleKey.class, "j_1", (bndl, bkey) -> {
            ((StoredBundlePersistenceImpl)bndl.getPersistenceDelegate()).getKeysBlunt().addBlunt(bkey);
            ((StoredBundleKeyPersistenceImpl)bkey.getPersistenceDelegate()).setBundleBlunt((StoredBundle)bndl);
        }));
        PreparedStatementWrapper st = this.getPreparedStatement(FIND_BY_NAME_AND_LOCALE_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_LOCALE));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            js.createJoinedSql(this.pdo(), sql);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, name);
        st.setString(ndx++, locale, true);
        return (StoredBundle)this.executeFirstPdoQuery(st, js);
    }

    static {
        FIND_BY_NAME_STMT = new StatementId();
        FIND_BY_NAME_AND_LOCALE_STMT = new StatementId();
    }
}

