/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n.pdo;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Objects;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.i18n.pdo.StoredBundleKeyPersistence;
import org.tentackle.i18n.pdo.rmi.StoredBundleKeyRemoteDelegate;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextDependable;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Persistent;
import org.tentackle.session.Session;
import org.tentackle.session.SessionDependable;

@PersistentObjectService(value=StoredBundleKey.class)
public class StoredBundleKeyPersistenceImpl
extends AbstractPersistentObject<StoredBundleKey, StoredBundleKeyPersistenceImpl>
implements StoredBundleKeyPersistence {
    private static final long serialVersionUID = -1178387730540795319L;
    public static final PersistentObjectClassVariables<StoredBundleKey, StoredBundleKeyPersistenceImpl> CLASSVARIABLES = new PersistentObjectClassVariables(StoredBundleKey.class, StoredBundleKeyPersistenceImpl.class, "bkey", null, null);
    public static final String CN_BUNDLEID = "bundle_id";
    public static final String CN_KEY = "bkey";
    public static final String CN_VALUE = "bvalue";
    @Persistent(value="the bundle id")
    private long bundleId;
    @Persistent(value="the resource bundle key")
    private String key;
    @Persistent(value="the localized string")
    private String value;
    private StoredBundle bundle;
    private boolean bundleLoaded;
    private static final StatementId SELECT_BY_BUNDLE_ID_STMT = new StatementId();

    public PersistentObjectClassVariables<StoredBundleKey, StoredBundleKeyPersistenceImpl> getClassVariables() {
        return CLASSVARIABLES;
    }

    public StoredBundleKeyPersistenceImpl(StoredBundleKey pdo, DomainContext context) {
        super((PersistentDomainObject)pdo, context);
    }

    public StoredBundleKeyPersistenceImpl(StoredBundleKey pdo, Session session) {
        super((PersistentDomainObject)pdo, session);
    }

    public StoredBundleKeyPersistenceImpl(StoredBundleKey pdo) {
        super((PersistentDomainObject)pdo);
    }

    public StoredBundleKeyPersistenceImpl() {
    }

    public StoredBundleKeyRemoteDelegate getRemoteDelegate() {
        return (StoredBundleKeyRemoteDelegate)super.getRemoteDelegate();
    }

    public long getRootId() {
        return this.bundleId;
    }

    public int getRootClassId() {
        return 8;
    }

    public boolean isTracked() {
        return true;
    }

    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_BUNDLEID);
            rs.configureColumn(CN_KEY);
            rs.configureColumn(CN_VALUE);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.bundleId = rs.getLong();
        this.key = rs.getString();
        this.value = rs.getString();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setLong(++ndx, this.bundleId);
        st.setString(++ndx, this.key);
        st.setString(++ndx, this.value);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + CN_BUNDLEID + "," + CN_KEY + "," + CN_VALUE + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + CN_BUNDLEID + "=?," + CN_KEY + "=?," + CN_VALUE + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    private void setBundleId(long bundleId) {
        this.assertMutable();
        if (this.bundleId != bundleId) {
            this.setModified(true);
        }
        this.bundleId = bundleId;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.assertMutable();
        if (!Objects.equals(this.key, key)) {
            this.setModified(true);
        }
        this.key = key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.assertMutable();
        if (!Objects.equals(this.value, value)) {
            this.setModified(true);
        }
        this.value = value;
    }

    protected void revertAttributesToSnapshot(StoredBundleKeyPersistenceImpl snapshot) {
        super.revertAttributesToSnapshot((AbstractPersistentObject)snapshot);
        this.bundleId = snapshot.bundleId;
        this.key = snapshot.key;
        this.value = snapshot.value;
    }

    @Override
    public StoredBundle getBundle() {
        if (!this.bundleLoaded) {
            this.bundle = this.bundleId == 0L ? null : (StoredBundle)((StoredBundle)this.on(StoredBundle.class)).select(this.bundleId);
            this.bundleLoaded = true;
        }
        return this.bundle;
    }

    public StoredBundle getBundleBlunt() {
        return this.bundle;
    }

    @Override
    public void setBundle(StoredBundle bundle) {
        this.assertMutable();
        this.bundle = bundle;
        this.setBundleId(bundle == null ? 0L : bundle.getId());
        this.bundleLoaded = true;
    }

    public void setBundleBlunt(StoredBundle bundle) {
        this.bundle = bundle;
        this.bundleLoaded = true;
    }

    public void setSession(Session session) {
        super.setSession(session);
        session.applyTo((SessionDependable)this.bundle);
    }

    public void setDomainContext(DomainContext context) {
        super.setDomainContext(context);
        context.applyTo((DomainContextDependable)this.bundle);
    }

    @Override
    public TrackedList<StoredBundleKey> selectByBundleId(long bundleId) {
        if (this.getSession().isRemote()) {
            try {
                TrackedList<StoredBundleKey> list = this.getRemoteDelegate().selectByBundleId(this.getDomainContext(), bundleId);
                this.configureRemoteObjects(this.getDomainContext(), (Collection)list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_BUNDLE_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_BUNDLEID));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, bundleId);
        return this.executeTrackedListQuery(st);
    }
}

