/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.i18n.pdo;

import org.tentackle.session.ClassId;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.Plural;
import org.tentackle.pdo.Singular;
import org.tentackle.session.TableName;


/**
 * @> $mapping
 *
 * # bundle key with translation
 * name := $classname
 * id := $classid
 * table := $tablename
 * alias := bkey
 * integrity := composite
 *
 * ## attributes
 * [remote, tracked]
 *
 * long           bundleId          bundle_id        the bundle id
 * String         key               bkey             the resource bundle key
 * String         value             bvalue           the localized string
 *
 * ## indexes
 * index bundle := bundle_id
 *
 * ## validations
 * key: @NotNull
 * value: @NotNull
 *
 * ## relations
 * StoredBundle:
 *    relation = serialized,
 *    name = Bundle
 *
 * @<
 */


/**
 * A bundle key translation stored in the database.
 * <p>
 *
 * @author harald
 */
@TableName(/**/"bundlekey"/**/) // @wurblet < Inject --string $tablename
@ClassId(/**/9/**/) // @wurblet < Inject $classid
@Singular("bundle key")
@Plural("bundle keys")
public interface StoredBundleKey
       extends PersistentDomainObject<StoredBundleKey>, StoredBundleKeyDomain, StoredBundleKeyPersistence {

  // @wurblet(fold=expanded) modelComment ModelComment

  // <editor-fold defaultstate="expanded" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:modelComment

  /*
   * -------------------------------------------------------------------------------------------------------------------
   *
   * StoredBundleKey is referenced by:
   *
   * StoredBundle via bkey.bundleId as keys [1:N]
   *
   *
   * StoredBundleKey is referencing the following entities:
   *
   * StoredBundle via bundleId [1:1]
   *
   *
   * StoredBundleKey is a component of: StoredBundle
   * and belongs to the root entity: StoredBundle
   *
   *
   * StoredBundleKey is not extended
   *
   * -------------------------------------------------------------------------------------------------------------------
   */

  // </editor-fold>//GEN-END:modelComment

}
