/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.i18n.pdo;

import org.tentackle.bind.Bindable;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.session.Persistent;
import org.tentackle.validate.validator.NotNull;

/**
 * Persistence interface for stored bundle keys.
 *
 * @author harald
 */
public interface StoredBundleKeyPersistence extends PersistentObject<StoredBundleKey> {

  // @wurblet fieldlengths ColumnLengths

// <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:fieldlengths


// </editor-fold>//GEN-END:fieldlengths

  // @wurblet membernames AttributeNames

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:membernames


  /** relation name for 'StoredBundle bundle via bundleId (Bundle)'. */
  String RN_BUNDLE = "bundle";

  /** attribute name for database column 'bundle_id'. */
  String AN_BUNDLEID = "bundleId";

  /** attribute name for database column 'bkey'. */
  String AN_KEY = "key";

  /** attribute name for database column 'bvalue'. */
  String AN_VALUE = "value";

  // </editor-fold>//GEN-END:membernames

  // @wurblet methods Methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:methods


  /**
   * Gets the attribute bundleId.
   *
   * @return the bundle id
   */
  @Persistent("the bundle id")
  long getBundleId();

  /**
   * Gets the attribute key.
   *
   * @return the resource bundle key
   */
  @Persistent("the resource bundle key")
  @NotNull
  String getKey();

  /**
   * Sets the attribute key.
   *
   * @param key the resource bundle key
   */
  void setKey(String key);

  /**
   * Gets the attribute value.
   *
   * @return the localized string
   */
  @Persistent("the localized string")
  @NotNull
  String getValue();

  /**
   * Sets the attribute value.
   *
   * @param value the localized string
   */
  void setValue(String value);

  // </editor-fold>//GEN-END:methods

  // @wurblet relations Relations

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:relations


  /**
   * StoredBundleKey is referenced by:
   * composite list of StoredBundleKey keys via StoredBundleKey#bundleId (Keys)
   */

  /**
   * Gets StoredBundle bundle via bundleId (Bundle).
   *
   * @return bundle Bundle
   */
  @Bindable
  @Persistent(value="Bundle", component=false)
  StoredBundle getBundle();

  /**
   * Sets StoredBundle bundle via bundleId (Bundle).
   *
   * @param bundle Bundle
   */
  void setBundle(StoredBundle bundle);

  /**
   * Selects composite list of StoredBundleKey keys via StoredBundleKey#bundleId (Keys).
   *
   * @param bundleId the bundle id
   * @return Keys
   */
  TrackedList<StoredBundleKey> selectByBundleId(long bundleId);

  // </editor-fold>//GEN-END:relations

}
