/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.session.Session;

public class StoredBundleControl
extends ResourceBundle.Control
implements DomainContextProvider {
    public static boolean fallbackToPropertyFile = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(StoredBundleControl.class);
    private static final List<String> FORMATS = Arrays.asList("");
    private DomainContext context;

    public DomainContext getDomainContext() {
        return this.context;
    }

    @Override
    public List<String> getFormats(String baseName) {
        if (Session.getCurrentSession() == null) {
            return super.getFormats(baseName);
        }
        if (baseName == null) {
            throw new NullPointerException();
        }
        return FORMATS;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (Session.getCurrentSession() == null) {
            return super.newBundle(baseName, locale, format, loader, reload);
        }
        if (this.context == null) {
            this.context = Pdo.createDomainContext();
        }
        if (baseName == null || locale == null || format == null || loader == null) {
            throw new IllegalArgumentException("baseName, locale, format and loader must not be null");
        }
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, format);
        String name = resourceName.substring(0, resourceName.length() - 1);
        String loc = null;
        int ndx = name.indexOf(95);
        if (ndx >= 0) {
            loc = name.substring(ndx + 1);
            name = name.substring(0, ndx);
        }
        String locText = loc == null ? "" : loc;
        StoredBundle bundle = ((StoredBundle)this.on(StoredBundle.class)).selectCachedByUniqueDomainKey(new StoredBundle.StoredBundleUDK(name, loc));
        if (bundle != null) {
            LOGGER.info("stored bundle {0}[{1}] loaded", new Object[]{name, locText});
            return new StoredResourceBundle(bundle);
        }
        if (fallbackToPropertyFile) {
            ResourceBundle rb;
            LOGGER.fine("no stored bundle {0}[{1}] -> trying property file ...", new Object[]{name, locText});
            if (format.isEmpty()) {
                format = "java.properties";
            }
            if ((rb = super.newBundle(baseName, locale, format, loader, reload)) != null) {
                LOGGER.info("property bundle {0}[{1}] loaded", new Object[]{name, locText});
            }
            return rb;
        }
        return null;
    }

    private static class BundleEnumeration
    implements Enumeration<String> {
        private final Set<String> keys;
        private final Iterator<String> iterator;
        private final Enumeration<String> parentEnumeration;
        private String next = null;

        public BundleEnumeration(Set<String> keys, Enumeration<String> parentEnumeration) {
            this.keys = keys;
            this.iterator = keys.iterator();
            this.parentEnumeration = parentEnumeration;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else if (this.parentEnumeration != null) {
                    while (this.next == null && this.parentEnumeration.hasMoreElements()) {
                        this.next = this.parentEnumeration.nextElement();
                        if (!this.keys.contains(this.next)) continue;
                        this.next = null;
                    }
                }
            }
            return this.next != null;
        }

        @Override
        public String nextElement() {
            if (this.hasMoreElements()) {
                String result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }

    private static class StoredResourceBundle
    extends ResourceBundle {
        private final Properties props = new Properties();
        private final String name;

        private StoredResourceBundle(StoredBundle bundle) {
            this.name = bundle.toString();
            for (StoredBundleKey bundleKey : bundle.getKeys()) {
                this.props.setProperty(bundleKey.getKey(), bundleKey.getValue());
            }
        }

        @Override
        protected Object handleGetObject(String key) {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            return this.props.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            ResourceBundle p = this.parent;
            return new BundleEnumeration(this.props.stringPropertyNames(), p != null ? p.getKeys() : null);
        }

        public String toString() {
            return this.name;
        }
    }
}

