/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log.log4j;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.tentackle.common.Service;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.log.MappedDiagnosticContext;
import org.tentackle.log.log4j.Log4JMappedDiagnosticContext;

@Service(value=Logger.class)
public class Log4JLogger
implements Logger {
    private static final String FQCN = Log4JLogger.class.getName();
    private static final HashMap<String, Log4JLogger> LOGGERS = new HashMap();
    private final org.apache.log4j.Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log4JLogger getLogger(String name) {
        HashMap<String, Log4JLogger> hashMap = LOGGERS;
        synchronized (hashMap) {
            return LOGGERS.computeIfAbsent(name, Log4JLogger::new);
        }
    }

    public Log4JLogger(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public Object getLoggerImpl() {
        return this.logger;
    }

    public boolean isLoggable(Logger.Level level) {
        return this.logger.isEnabledFor((Priority)this.translateLevel(level));
    }

    public void log(Logger.Level level, String message, Throwable cause) {
        this.doLog(level, message, cause, new Object[0]);
    }

    public void log(Logger.Level level, Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(level, cause, (String)null, messageSupplier);
    }

    public void finer(String message) {
        this.doLog(Logger.Level.FINER, message, null, new Object[0]);
    }

    public void fine(String message) {
        this.doLog(Logger.Level.FINE, message, null, new Object[0]);
    }

    public void info(String message) {
        this.doLog(Logger.Level.INFO, message, null, new Object[0]);
    }

    public void warning(String message) {
        this.doLog(Logger.Level.WARNING, message, null, new Object[0]);
    }

    public void severe(String message) {
        this.doLog(Logger.Level.SEVERE, message, null, new Object[0]);
    }

    public void finer(String message, Object ... params) {
        this.doLog(Logger.Level.FINER, message, null, params);
    }

    public void fine(String message, Object ... params) {
        this.doLog(Logger.Level.FINE, message, null, params);
    }

    public void info(String message, Object ... params) {
        this.doLog(Logger.Level.INFO, message, null, params);
    }

    public void warning(String message, Object ... params) {
        this.doLog(Logger.Level.WARNING, message, null, params);
    }

    public void severe(String message, Object ... params) {
        this.doLog(Logger.Level.SEVERE, message, null, params);
    }

    public void finer(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.FINER, null, message, paramSuppliers);
    }

    public void fine(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.FINE, null, message, paramSuppliers);
    }

    public void info(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.INFO, null, message, paramSuppliers);
    }

    public void warning(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.WARNING, null, message, paramSuppliers);
    }

    public void severe(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.SEVERE, null, message, paramSuppliers);
    }

    public void finer(String message, Throwable cause) {
        this.doLog(Logger.Level.FINER, message, cause, new Object[0]);
    }

    public void fine(String message, Throwable cause) {
        this.doLog(Logger.Level.FINE, message, cause, new Object[0]);
    }

    public void info(String message, Throwable cause) {
        this.doLog(Logger.Level.INFO, message, cause, new Object[0]);
    }

    public void warning(String message, Throwable cause) {
        this.doLog(Logger.Level.WARNING, message, cause, new Object[0]);
    }

    public void severe(String message, Throwable cause) {
        this.doLog(Logger.Level.SEVERE, message, cause, new Object[0]);
    }

    public void finer(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINER, cause, (String)null, messageSupplier);
    }

    public void fine(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINE, cause, (String)null, messageSupplier);
    }

    public void info(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.INFO, cause, (String)null, messageSupplier);
    }

    public void warning(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.WARNING, cause, (String)null, messageSupplier);
    }

    public void severe(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.SEVERE, cause, (String)null, messageSupplier);
    }

    public void finer(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINER, (Throwable)null, (String)null, messageSupplier);
    }

    public void fine(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINE, (Throwable)null, (String)null, messageSupplier);
    }

    public void info(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.INFO, (Throwable)null, (String)null, messageSupplier);
    }

    public void warning(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.WARNING, (Throwable)null, (String)null, messageSupplier);
    }

    public void severe(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.SEVERE, (Throwable)null, (String)null, messageSupplier);
    }

    public boolean isFinerLoggable() {
        return this.isLoggable(Logger.Level.FINER);
    }

    public boolean isFineLoggable() {
        return this.isLoggable(Logger.Level.FINE);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(Logger.Level.INFO);
    }

    public boolean isWarningLoggable() {
        return this.isLoggable(Logger.Level.WARNING);
    }

    public boolean isSevereLoggable() {
        return this.isLoggable(Logger.Level.SEVERE);
    }

    public void logStacktrace(Logger.Level level, Throwable cause) {
        try (PrintStream ps = new PrintStream((OutputStream)new LoggerOutputStream((Logger)this, level));){
            cause.printStackTrace(ps);
        }
    }

    public void logStacktrace(Throwable cause) {
        this.logStacktrace(Logger.Level.SEVERE, cause);
    }

    public MappedDiagnosticContext getMappedDiagnosticContext() {
        return Log4JMappedDiagnosticContext.getInstance();
    }

    protected Level translateLevel(Logger.Level level) {
        switch (level) {
            case FINER: {
                return Level.TRACE;
            }
            case FINE: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARN;
            }
        }
        return Level.ERROR;
    }

    protected void doLog(Logger.Level level, String message, Throwable cause, Object ... params) {
        this.doLog(level, cause, (String)null, () -> params != null && params.length > 0 ? MessageFormat.format(message, params) : message);
    }

    protected void doLog(Logger.Level level, Throwable cause, String message, Supplier<?> ... paramSuppliers) {
        this.doLog(level, cause, (String)null, () -> {
            Object[] params = new Object[paramSuppliers.length];
            for (int i = 0; i < params.length; ++i) {
                Supplier supplier = paramSuppliers[i];
                params[i] = supplier == null ? null : supplier.get();
            }
            return MessageFormat.format(message, params);
        });
    }

    protected void doLog(Logger.Level level, Throwable cause, String message, Supplier<String> messageSupplier) {
        if (messageSupplier != null) {
            if (!this.isLoggable(level)) {
                return;
            }
            message = messageSupplier.get();
        }
        this.logger.log(FQCN, (Priority)this.translateLevel(level), (Object)message, cause);
    }
}

