/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.tentackle.common.Service;
import org.tentackle.log.Log4JMappedDiagnosticContext;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.log.MappedDiagnosticContext;

@Service(value=Logger.class)
public class Log4JLogger
implements Logger {
    private static final String EXCLUDE_CLASSNAME = Log4JLogger.class.getName();
    private static final HashMap<String, Log4JLogger> loggers = new HashMap();
    private final org.apache.log4j.Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log4JLogger getLogger(String name) {
        HashMap<String, Log4JLogger> hashMap = loggers;
        synchronized (hashMap) {
            Log4JLogger logger = loggers.get(name);
            if (logger == null) {
                logger = new Log4JLogger(name);
                loggers.put(name, logger);
            }
            return logger;
        }
    }

    public Log4JLogger(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public Object getLoggerImpl() {
        return this.logger;
    }

    public boolean isLoggable(Logger.Level level) {
        return this.logger.isEnabledFor((Priority)this.translateLevel(level));
    }

    public void log(Logger.Level level, String message, Throwable cause) {
        this.doLog(level, message, cause, new Object[0]);
    }

    public void finest(String message, Throwable cause) {
        this.doLog(Logger.Level.FINEST, message, cause, new Object[0]);
    }

    public void finer(String message, Throwable cause) {
        this.doLog(Logger.Level.FINER, message, cause, new Object[0]);
    }

    public void fine(String message, Throwable cause) {
        this.doLog(Logger.Level.FINE, message, cause, new Object[0]);
    }

    public void info(String message, Throwable cause) {
        this.doLog(Logger.Level.INFO, message, cause, new Object[0]);
    }

    public void warning(String message, Throwable cause) {
        this.doLog(Logger.Level.WARNING, message, cause, new Object[0]);
    }

    public void severe(String message, Throwable cause) {
        this.doLog(Logger.Level.SEVERE, message, cause, new Object[0]);
    }

    public void finest(String message, Object ... params) {
        this.doLog(Logger.Level.FINEST, message, null, params);
    }

    public void finer(String message, Object ... params) {
        this.doLog(Logger.Level.FINER, message, null, params);
    }

    public void fine(String message, Object ... params) {
        this.doLog(Logger.Level.FINE, message, null, params);
    }

    public void info(String message, Object ... params) {
        this.doLog(Logger.Level.INFO, message, null, params);
    }

    public void warning(String message, Object ... params) {
        this.doLog(Logger.Level.WARNING, message, null, params);
    }

    public void severe(String message, Object ... params) {
        this.doLog(Logger.Level.SEVERE, message, null, params);
    }

    public boolean isFinestLoggable() {
        return this.isLoggable(Logger.Level.FINEST);
    }

    public boolean isFinerLoggable() {
        return this.isLoggable(Logger.Level.FINER);
    }

    public boolean isFineLoggable() {
        return this.isLoggable(Logger.Level.FINE);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(Logger.Level.INFO);
    }

    public boolean isWarningLoggable() {
        return this.isLoggable(Logger.Level.WARNING);
    }

    public boolean isSevereLoggable() {
        return this.isLoggable(Logger.Level.SEVERE);
    }

    public void logStacktrace(Logger.Level level, Throwable cause) {
        try (PrintStream ps = new PrintStream((OutputStream)new LoggerOutputStream((Logger)this, level));){
            cause.printStackTrace(ps);
        }
    }

    public void logStacktrace(Throwable cause) {
        this.logStacktrace(Logger.Level.SEVERE, cause);
    }

    public MappedDiagnosticContext getMappedDiagnosticContext() {
        return Log4JMappedDiagnosticContext.getInstance();
    }

    protected Level translateLevel(Logger.Level level) {
        switch (level) {
            case FINEST: {
                return Level.ALL;
            }
            case FINER: {
                return Level.TRACE;
            }
            case FINE: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARN;
            }
        }
        return Level.FATAL;
    }

    protected void doLog(Logger.Level level, String message, Throwable cause, Object ... params) {
        if (params != null && params.length > 0) {
            if (!this.isLoggable(level)) {
                return;
            }
            message = MessageFormat.format(message, params);
        }
        this.logger.log(EXCLUDE_CLASSNAME, (Priority)this.translateLevel(level), (Object)message, cause);
    }
}

