/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log.slf4j;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;
import org.tentackle.common.Service;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.log.MappedDiagnosticContext;
import org.tentackle.log.slf4j.SLF4JMappedDiagnosticContext;

@Service(value=Logger.class)
public class SLF4JLogger
implements Logger {
    private static final String EXCLUDE_CLASSNAME = SLF4JLogger.class.getName();
    private static final HashMap<String, SLF4JLogger> LOGGERS = new HashMap();
    private final org.slf4j.Logger logger;
    private final boolean locationAware;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SLF4JLogger getLogger(String name) {
        HashMap<String, SLF4JLogger> hashMap = LOGGERS;
        synchronized (hashMap) {
            SLF4JLogger logger = LOGGERS.get(name);
            if (logger == null) {
                logger = new SLF4JLogger(name);
                LOGGERS.put(name, logger);
            }
            return logger;
        }
    }

    public SLF4JLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.locationAware = this.logger instanceof LocationAwareLogger;
    }

    public Object getLoggerImpl() {
        return this.logger;
    }

    public boolean isLoggable(Logger.Level level) {
        switch (level) {
            case FINER: {
                return this.isFinerLoggable();
            }
            case FINE: {
                return this.isFineLoggable();
            }
            case INFO: {
                return this.isInfoLoggable();
            }
            case WARNING: {
                return this.isWarningLoggable();
            }
        }
        return this.isSevereLoggable();
    }

    public void log(Logger.Level level, String message, Throwable cause) {
        this.doLog(level, message, cause, new Object[0]);
    }

    public void finer(String message, Throwable cause) {
        this.doLog(Logger.Level.FINER, message, cause, new Object[0]);
    }

    public void fine(String message, Throwable cause) {
        this.doLog(Logger.Level.FINE, message, cause, new Object[0]);
    }

    public void info(String message, Throwable cause) {
        this.doLog(Logger.Level.INFO, message, cause, new Object[0]);
    }

    public void warning(String message, Throwable cause) {
        this.doLog(Logger.Level.WARNING, message, cause, new Object[0]);
    }

    public void severe(String message, Throwable cause) {
        this.doLog(Logger.Level.SEVERE, message, cause, new Object[0]);
    }

    public void finer(String message, Object ... params) {
        this.doLog(Logger.Level.FINER, message, null, params);
    }

    public void fine(String message, Object ... params) {
        this.doLog(Logger.Level.FINE, message, null, params);
    }

    public void info(String message, Object ... params) {
        this.doLog(Logger.Level.INFO, message, null, params);
    }

    public void warning(String message, Object ... params) {
        this.doLog(Logger.Level.WARNING, message, null, params);
    }

    public void severe(String message, Object ... params) {
        this.doLog(Logger.Level.SEVERE, message, null, params);
    }

    public boolean isFinerLoggable() {
        return this.logger.isTraceEnabled();
    }

    public boolean isFineLoggable() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoLoggable() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarningLoggable() {
        return this.logger.isWarnEnabled();
    }

    public boolean isSevereLoggable() {
        return this.logger.isErrorEnabled();
    }

    public void logStacktrace(Logger.Level level, Throwable cause) {
        try (PrintStream ps = new PrintStream((OutputStream)new LoggerOutputStream((Logger)this, level));){
            cause.printStackTrace(ps);
        }
    }

    public void logStacktrace(Throwable cause) {
        this.logStacktrace(Logger.Level.SEVERE, cause);
    }

    public MappedDiagnosticContext getMappedDiagnosticContext() {
        return SLF4JMappedDiagnosticContext.getInstance();
    }

    protected int translateLevel(Logger.Level level) {
        switch (level) {
            case FINER: {
                return 0;
            }
            case FINE: {
                return 10;
            }
            case INFO: {
                return 20;
            }
            case WARNING: {
                return 30;
            }
        }
        return 40;
    }

    protected boolean isLocationAware() {
        return this.locationAware;
    }

    protected void doLog(Logger.Level level, String message, Throwable cause, Object ... params) {
        if (params != null && params.length > 0) {
            if (!this.isLoggable(level)) {
                return;
            }
            message = MessageFormat.format(message, params);
        }
        if (this.isLocationAware()) {
            ((LocationAwareLogger)this.logger).log(null, EXCLUDE_CLASSNAME, this.translateLevel(level), message, null, cause);
        } else {
            switch (level) {
                case FINER: {
                    this.logger.trace(message, cause);
                    break;
                }
                case FINE: {
                    this.logger.debug(message, cause);
                    break;
                }
                case INFO: {
                    this.logger.info(message, cause);
                    break;
                }
                case WARNING: {
                    this.logger.warn(message, cause);
                    break;
                }
                default: {
                    this.logger.error(message, cause);
                }
            }
        }
    }
}

