/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.AbstractTentackleMojo;

public abstract class AbstractVersionInfoMojo
extends AbstractTentackleMojo {
    protected String generateVersionProperties(Set<Artifact> artifacts) {
        TreeMap<String, String> versionsMap = new TreeMap<String, String>();
        for (Artifact artifact : artifacts) {
            versionsMap.put(this.createPropertyName(artifact), artifact.getVersion());
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : versionsMap.entrySet()) {
            String name = (String)entry.getKey();
            String version = (String)entry.getValue();
            buf.append('\n').append("<").append(name).append(">").append(version).append("</").append(name).append(">");
        }
        return buf.toString();
    }

    private String createPropertyName(Artifact artifact) {
        return "version." + this.camalize(artifact.getGroupId()) + "." + this.camalize(artifact.getArtifactId());
    }

    private String camalize(String str) {
        return StringHelper.toCamelCase((String)str.replace('-', '.').replace('_', '.'));
    }
}

