/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.plugin.AbstractVersionInfoMojo;

@Mojo(name="versions", aggregator=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class VersionInfoMojo
extends AbstractVersionInfoMojo {
    @Parameter(property="scope")
    private String scope;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    private Set<Artifact> modules;
    private final Set<Artifact> artifacts = new HashSet<Artifact>();

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (this.getMavenSession().getTopLevelProject().equals((Object)this.getMavenProject())) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getMavenSession().getProjectBuildingRequest());
            List allProjects = this.getMavenProject().getCollectedProjects();
            if (allProjects.isEmpty()) {
                allProjects.add(this.getMavenProject());
            }
            this.modules = allProjects.stream().map(MavenProject::getArtifact).collect(Collectors.toSet());
            for (MavenProject subProject : allProjects) {
                buildingRequest.setProject(subProject);
                try {
                    this.scanNode(this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null, List.of(subProject)));
                }
                catch (DependencyGraphBuilderException e) {
                    throw new MojoExecutionException("scanning for dependencies failed", (Exception)((Object)e));
                }
            }
            String versions = this.generateVersionProperties(this.artifacts);
            Object depStr = "dependencies";
            if (this.scope != null) {
                depStr = (String)depStr + " for scope '" + this.scope + "'";
            }
            if (versions.isEmpty()) {
                this.getLog().warn((CharSequence)("no 3rd-party " + (String)depStr + " found"));
            } else {
                this.getLog().info((CharSequence)("versions of 3rd-party " + (String)depStr + ":" + versions));
            }
        } else {
            this.getLog().info((CharSequence)"skipped");
        }
    }

    protected boolean validate() throws MojoExecutionException {
        if (this.scope != null) {
            this.scope = StringHelper.isAllWhitespace((String)this.scope) ? null : this.scope.toLowerCase();
        }
        return super.validate();
    }

    private void scanNode(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String artifactScope = artifact.getScope();
        artifactScope = artifactScope == null ? this.scope : artifactScope.toLowerCase();
        if (this.scope == null || Objects.equals(artifactScope, this.scope)) {
            if (!this.modules.contains(artifact)) {
                this.artifacts.add(artifact);
            }
            node.getChildren().forEach(this::scanNode);
        }
    }
}

