/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.AbstractTentackleMojo;

public abstract class AbstractVersionInfoMojo
extends AbstractTentackleMojo {
    @Parameter(property="outputFile")
    private File outputFile;
    @Parameter(property="groupVersions")
    private int groupVersions;

    protected void generateVersionProperties(String comment, Set<Artifact> artifacts) throws MojoExecutionException {
        TreeMap<String, String> versionsMap = new TreeMap<String, String>();
        HashMap<Group, List> groupMap = new HashMap<Group, List>();
        for (Artifact artifact : artifacts) {
            versionsMap.put(this.createPropertyName(artifact), artifact.getVersion());
            if (this.groupVersions == 0) continue;
            groupMap.computeIfAbsent(new Group(artifact.getGroupId(), artifact.getVersion()), group -> new ArrayList()).add(artifact);
        }
        if (this.isPropertiesFile()) {
            try (FileWriter writer = new FileWriter(this.outputFile, Settings.getEncodingCharset());){
                Properties properties = new Properties();
                for (Map.Entry entry : versionsMap.entrySet()) {
                    properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                properties.store(writer, comment);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not write properties file", (Exception)e);
            }
        }
        if (!groupMap.isEmpty()) {
            HashMap<String, Group> reducedGroupMap = new HashMap<String, Group>();
            for (Map.Entry entry : groupMap.entrySet()) {
                String groupId = ((Group)entry.getKey()).groupId;
                Group group2 = (Group)reducedGroupMap.get(groupId);
                if (group2 != null && ((List)entry.getValue()).size() <= ((List)groupMap.get(group2)).size()) continue;
                reducedGroupMap.put(groupId, (Group)entry.getKey());
            }
            Iterator iterator = groupMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                entry = iterator.next();
                int size = ((List)entry.getValue()).size();
                String groupId = ((Group)entry.getKey()).groupId;
                if (reducedGroupMap.containsValue(entry.getKey()) && (this.groupVersions <= 0 || size >= this.groupVersions) && (this.groupVersions >= 0 || size != 1 && size - this.groupVersions >= artifacts.stream().filter(a -> a.getGroupId().equals(groupId)).collect(Collectors.toList()).size())) continue;
                iterator.remove();
            }
            for (Group group3 : groupMap.keySet()) {
                String groupProperty = this.createGroupPropertyName(group3.groupId);
                String groupLead = groupProperty + ".";
                versionsMap.put(groupProperty, group3.version);
                for (Map.Entry entry : versionsMap.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(groupLead) || !((String)entry.getValue()).equals(group3.version)) continue;
                    entry.setValue((CallSite)((Object)("${" + groupProperty + "}")));
                }
            }
        }
        StringBuilder xmlBuf = new StringBuilder();
        xmlBuf.append("<!-- ").append(comment).append(" -->");
        for (Map.Entry entry : versionsMap.entrySet()) {
            String name = (String)entry.getKey();
            String version = (String)entry.getValue();
            xmlBuf.append('\n').append("<").append(name).append(">").append(version).append("</").append(name).append(">");
        }
        String xml = xmlBuf.toString();
        if (this.outputFile != null && !this.isPropertiesFile()) {
            try (FileWriter writer = new FileWriter(this.outputFile, Settings.getEncodingCharset());){
                ((Writer)writer).append(xml);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not write XML file", (Exception)e);
            }
        }
        if (versionsMap.isEmpty()) {
            this.getLog().warn((CharSequence)"no artifacts found");
        } else {
            this.getLog().info((CharSequence)("\n" + xml));
        }
    }

    private String createGroupPropertyName(String groupId) {
        return "version." + this.camelize(groupId);
    }

    private String createPropertyName(Artifact artifact) {
        return this.createGroupPropertyName(artifact.getGroupId()) + "." + this.camelize(artifact.getArtifactId());
    }

    private String camelize(String str) {
        return StringHelper.toCamelCase((String)str.replace('-', '.').replace('_', '.'));
    }

    private boolean isPropertiesFile() {
        return this.outputFile != null && this.outputFile.getName().endsWith(".properties");
    }

    private static class Group {
        private final String groupId;
        private final String version;

        private Group(String groupId, String version) {
            this.groupId = groupId;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            if (!this.groupId.equals(group.groupId)) {
                return false;
            }
            return this.version.equals(group.version);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }
    }
}

