/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.tentackle.maven.AbstractTentackleMojo;

@Mojo(name="beaninfo", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BeanInfoMojo
extends AbstractTentackleMojo {
    private static final String MANIFEST_FILENAME = "MANIFEST.MF";
    private static final String BEANINFO_TRAILER = "BeanInfo.java";
    @Parameter
    protected List<FileSet> filesets;
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="tentackle.sourceDir", required=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/manifest", property="tentackle.manifestDirectory", required=true)
    private String manifestDirectory;
    private int totalErrors;

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.totalErrors = 0;
        File manifestDir = new File(this.manifestDirectory, "META-INF");
        manifestDir.mkdirs();
        File manifestFile = new File(manifestDir, MANIFEST_FILENAME);
        try (PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(manifestFile)));){
            ps.println("Manifest-Version: 1.0");
            ps.println("Archiver-Version: Plexus Archiver");
            ps.println("Created-By: Apache Maven");
            ps.println("Built-By: " + System.getProperty("user.name"));
            ps.println("Build-Jdk: " + Runtime.version());
            if (this.filesets != null && !this.filesets.isEmpty()) {
                for (FileSet fileSet : this.filesets) {
                    this.processFileSet(fileSet, ps);
                }
            } else {
                String[] files;
                String[] stringArray = files = this.sourceDir.isDirectory() ? this.sourceDir.list() : null;
                if (files != null && files.length > 0) {
                    FileSet fs = new FileSet();
                    fs.setDirectory(this.sourceDir.getPath());
                    fs.addInclude("**/*BeanInfo.java");
                    this.processFileSet(fs, ps);
                } else {
                    this.getLog().info((CharSequence)((this.sourceDir.exists() ? "empty" : "missing") + " source directory " + this.sourceDir.getAbsolutePath()));
                }
            }
        }
        catch (IOException iox) {
            throw new MojoExecutionException("failed to create manifest-file " + manifestFile.getAbsolutePath(), (Exception)iox);
        }
        if (this.totalErrors > 0) {
            throw new MojoFailureException(this.totalErrors + " beaninfo errors");
        }
    }

    private void processFileSet(FileSet fileSet, PrintStream ps) throws MojoExecutionException {
        if (fileSet.getDirectory() == null) {
            fileSet.setDirectory(this.sourceDir.getAbsolutePath());
        }
        File dir = new File(fileSet.getDirectory());
        String dirName = this.getCanonicalPath(dir);
        if (this.verbosityLevel.isDebug()) {
            this.getLog().info((CharSequence)("processing files in " + dirName));
        }
        int errorCount = 0;
        String[] fileNames = new FileSetManager(this.getLog(), this.verbosityLevel.isDebug()).getIncludedFiles(fileSet);
        if (fileNames.length > 0) {
            for (String fileName : fileNames) {
                int ndx = fileName.lastIndexOf(BEANINFO_TRAILER);
                if (ndx < 0) {
                    this.getLog().error((CharSequence)("file " + fileName + " does not end with BeanInfo.java"));
                    ++errorCount;
                    continue;
                }
                String beanInfoName = fileName.substring(0, ndx);
                File beanFile = new File(dir, beanInfoName + ".java");
                if (!beanFile.exists()) {
                    this.getLog().error((CharSequence)("no matching java-file for " + fileName));
                    ++errorCount;
                    continue;
                }
                if (beanInfoName.contains("Abstract")) continue;
                ps.println();
                ps.println("Name: " + beanInfoName + ".class");
                ps.println("Java-Bean: True");
            }
        }
        this.getLog().info((CharSequence)(this.getPathRelativeToBasedir(dirName) + ": " + fileNames.length + " files processed, " + errorCount + " errors"));
        this.totalErrors += errorCount;
    }

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.sourceDir == null) {
                throw new MojoExecutionException("missing tentackle.sourceDir");
            }
            return true;
        }
        return false;
    }
}

