/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.plugin.PropertyDescriptor;

@Mojo(name="properties", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PropertiesMojo
extends AbstractTentackleMojo {
    @Parameter
    private List<PropertyDescriptor> propertyDescriptors;
    private final Map<String, Function<String, String>> converterMap = new ConcurrentHashMap<String, Function<String, String>>();

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (this.propertyDescriptors != null) {
            for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
                String property = propertyDescriptor.getProperty();
                if (property == null) {
                    throw new MojoExecutionException("missing property name in property descriptor");
                }
                String converter = propertyDescriptor.getConverter();
                if (converter == null) {
                    throw new MojoExecutionException("missing converter in property descriptor");
                }
                Function function = this.converterMap.get(converter);
                if (function == null) {
                    String className = converter;
                    if (converter.startsWith("@")) {
                        className = converter.substring(1);
                        try {
                            className = (String)ServiceFactory.getServiceFinder().findFirstServiceConfiguration(className).getKey();
                        }
                        catch (TentackleRuntimeException ex) {
                            throw new MojoExecutionException("cannot load converter " + converter, (Exception)((Object)ex));
                        }
                    }
                    try {
                        Class<?> clazz = Class.forName(className);
                        if (!Function.class.isAssignableFrom(clazz)) {
                            throw new MojoExecutionException(clazz + " is not a java.util.Function");
                        }
                        Method method = clazz.getMethod("apply", String.class);
                        if (method.getReturnType() != String.class) {
                            throw new MojoExecutionException("method apply(String) of " + className + " does not return a String");
                        }
                        function = (Function)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        this.converterMap.put(converter, function);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new MojoExecutionException("no such converter: " + className, (Exception)e1);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new MojoExecutionException(className + " does not provide a method apply(String)", (Exception)e2);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e3) {
                        throw new MojoExecutionException(className + " cannot be instantiated", (Exception)e3);
                    }
                }
                String value = function.apply((String)propertyDescriptor.getInput());
                this.getMavenProject().getProperties().setProperty(property, value);
                if (!this.verbosityLevel.isInfo()) continue;
                this.getLog().info((CharSequence)("created property: " + property + " = " + value));
            }
        }
    }
}

