/*
 * Tentackle - https://tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed input the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.tentackle.maven.plugin;

/**
 * Descriptor for a property to be generated by {@link PropertiesMojo}.
 */
public class PropertyDescriptor {

  private String input;         // some input value
  private String converter;     // name of the converter singleton to locate via META-INF/services
  private String property;      // name of the generated property

  /**
   * Gets the input value.
   *
   * @return the input value to the converter
   */
  public String getInput() {
    return input;
  }

  /**
   * The converter.
   *
   * @return the FQCN of the converter, or the META-INF service if beginning with {@code @}
   */
  public String getConverter() {
    return converter;
  }

  /**
   * Gets the name of the property to generate
   *
   * @return the property name
   */
  public String getProperty() {
    return property;
  }

  public void setInput(String input) {
    this.input = input;
  }

  public void setConverter(String converter) {
    this.converter = converter;
  }

  public void setProperty(String property) {
    this.property = property;
  }
}
