/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.tentackle.maven.plugin.AbstractVersionInfoMojo;

@Mojo(name="plugin-versions", aggregator=true, defaultPhase=LifecyclePhase.VALIDATE)
public class PluginVersionInfoMojo
extends AbstractVersionInfoMojo {
    @Component
    private ArtifactResolver artifactResolver;

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (this.getMavenSession().getTopLevelProject().equals((Object)this.getMavenProject())) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getMavenSession().getProjectBuildingRequest());
            List allProjects = this.getMavenProject().getCollectedProjects();
            if (allProjects.isEmpty()) {
                allProjects.add(this.getMavenProject());
            }
            HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
            for (MavenProject subProject : allProjects) {
                buildingRequest.setProject(subProject);
                for (Artifact pluginArtifact : subProject.getPluginArtifacts()) {
                    try {
                        pluginArtifacts.add(this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, pluginArtifact).getArtifact());
                    }
                    catch (ArtifactResolverException e) {
                        throw new MojoExecutionException("cannot resolve plugin artifact", (Exception)((Object)e));
                    }
                }
            }
            this.generateVersionProperties("plugins of project '" + this.getMavenProject().getName() + "'", pluginArtifacts);
        } else {
            this.getLog().info((CharSequence)"skipped");
        }
    }
}

