/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.maven.AbstractTentackleAnnotationProcessingMojo;

public abstract class AbstractAnalyzeAnnotationProcessingMojo
extends AbstractTentackleAnnotationProcessingMojo {
    private File analyzeDir;
    private File servicesDir;

    public AbstractAnalyzeAnnotationProcessingMojo() {
        this.addProcessor((AbstractTentackleProcessor)new AnalyzeProcessor());
    }

    public void setMojoParameters(File sourceDir, File analyzeDir, File servicesDir, List<String> classpathElements) {
        super.setMojoParameters(sourceDir, classpathElements);
        this.analyzeDir = analyzeDir;
        this.servicesDir = servicesDir;
    }

    @Override
    protected void validate() throws MojoExecutionException {
        super.validate();
        if (this.analyzeDir == null) {
            throw new MojoExecutionException("missing tentackle.analyzeDir");
        }
        if (this.analyzeDir.getPath().contains("${")) {
            throw new MojoExecutionException("undefined variable(s) in analyzeDir: " + this.analyzeDir.getPath());
        }
        if (this.servicesDir == null) {
            throw new MojoExecutionException("missing tentackle.serviceDir");
        }
        if (this.servicesDir.getPath().contains("${")) {
            throw new MojoExecutionException("undefined variable(s) in servicesDir: " + this.servicesDir.getPath());
        }
    }

    @Override
    protected void createMissingDirs() {
        super.createMissingDirs();
        this.analyzeDir.mkdirs();
        this.servicesDir.mkdirs();
    }

    @Override
    protected void initializeProcessor(AbstractTentackleProcessor processor, File srcDir) {
        super.initializeProcessor(processor, srcDir);
        AnalyzeProcessor p = (AnalyzeProcessor)processor;
        p.setAnalyzeDir(this.analyzeDir);
        p.setServiceDir(this.servicesDir);
    }

    @Override
    protected String[] filterFileNames(String dirName, String[] fileNames) {
        ArrayList<String> filteredNames = new ArrayList<String>();
        for (String fileName : fileNames) {
            String sourceFilePath = dirName + File.separator + fileName;
            long sourceLastModified = new File(sourceFilePath).lastModified();
            String outputDirPath = this.analyzeDir.getAbsolutePath() + File.separator + fileName;
            int ndx = outputDirPath.lastIndexOf(46);
            if (ndx > 0) {
                outputDirPath = outputDirPath.substring(0, ndx);
            }
            long minOutputLastModified = 0L;
            File outputDir = new File(outputDirPath);
            if (outputDir.exists()) {
                minOutputLastModified = outputDir.lastModified();
                for (File file : outputDir.listFiles()) {
                    long lastModified = file.lastModified();
                    if (lastModified >= minOutputLastModified) continue;
                    minOutputLastModified = lastModified;
                }
            } else {
                outputDir.mkdirs();
            }
            if (minOutputLastModified < sourceLastModified) {
                filteredNames.add(fileName);
                continue;
            }
            if (!this.verbosityLevel.isDebug()) continue;
            this.getLog().info((CharSequence)("skipped unchanged " + sourceFilePath));
        }
        return filteredNames.toArray(new String[0]);
    }
}

