/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.wurbelizer.misc.Verbosity;

public abstract class AbstractTentackleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;
    @Parameter
    protected List<FileSet> filesets;
    @Parameter(defaultValue="${tentackle.verbosity}")
    protected String verbosity;
    protected Verbosity verbosityLevel;
    protected List<String> resourceDirs;

    protected void determineVerbosity() {
        if (this.verbosity != null) {
            try {
                this.verbosityLevel = Verbosity.valueOf((String)this.verbosity.toUpperCase());
            }
            catch (Exception ex) {
                this.verbosityLevel = Verbosity.DEFAULT;
            }
        } else {
            this.verbosityLevel = this.getLog().isDebugEnabled() ? Verbosity.DEBUG : Verbosity.DEFAULT;
        }
    }

    protected String getPathRelativeToBasedir(String path) {
        int ndx;
        for (String basePath = this.mavenProject.getBasedir().getAbsolutePath(); basePath != null && basePath.length() > 0; basePath = basePath.substring(0, ndx)) {
            if (path.startsWith(basePath)) {
                int len = basePath.lastIndexOf(File.separatorChar);
                len = len > 0 ? ++len : basePath.length() + 1;
                return path.substring(len);
            }
            ndx = basePath.lastIndexOf(File.separatorChar);
            if (ndx <= 0) break;
        }
        return path;
    }

    protected void findResourceDirs() {
        this.resourceDirs = new ArrayList<String>();
        for (Object resource : this.mavenProject.getBuild().getResources()) {
            String name;
            if (!(resource instanceof Resource) || (name = ((Resource)resource).getDirectory()) == null) continue;
            this.getLog().debug((CharSequence)("found resource directory " + name));
            this.resourceDirs.add(name);
        }
    }

    protected String getResourceDirName(String dirName) {
        if (this.resourceDirs != null) {
            for (String resourceDir : this.resourceDirs) {
                if (!dirName.startsWith(resourceDir)) continue;
                return resourceDir;
            }
        }
        return null;
    }

    protected String getCanonicalPath(File dir) throws MojoExecutionException {
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("cannot determine canonical path of " + dir, (Exception)ex);
        }
    }

    protected void validate() throws MojoExecutionException {
        this.determineVerbosity();
        if (this.mavenProject == null) {
            throw new MojoExecutionException("missing project");
        }
        if (this.mavenProject.getBasedir() == null) {
            throw new MojoExecutionException("missing project.baseDir");
        }
    }
}

