/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import com.sun.tools.javac.api.JavacTool;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.ProjectClassLoader;

public abstract class AbstractTentackleAnnotationProcessingMojo
extends AbstractTentackleMojo {
    @Parameter(defaultValue="${tentackle.showCompileOutput}")
    protected boolean showCompileOutput;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    private File sourceDir;
    private List<String> classpathElements;
    private int totalErrors;
    protected List<AbstractTentackleProcessor> processors;
    private ClassLoader processingClassloader;

    public void setMojoParameters(File sourceDir, List<String> classpathElements) throws MojoFailureException {
        this.sourceDir = sourceDir;
        this.classpathElements = classpathElements;
        try {
            this.processingClassloader = new ProjectClassLoader((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader(), classpathElements);
        }
        catch (MalformedURLException mx) {
            throw new MojoFailureException("cannot create project classloader", (Throwable)mx);
        }
    }

    public ClassLoader getProcessingClassloader() {
        return this.processingClassloader;
    }

    public void addProcessor(AbstractTentackleProcessor processor) {
        if (this.processors == null) {
            this.processors = new ArrayList<AbstractTentackleProcessor>();
        }
        this.processors.add(processor);
    }

    protected void createMissingDirs() {
    }

    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
    }

    public void finishExecute() throws MojoExecutionException, MojoFailureException {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.prepareExecute();
        this.validate();
        this.createMissingDirs();
        this.totalErrors = 0;
        if (this.filesets != null && this.filesets.size() > 0) {
            for (FileSet fileSet : this.filesets) {
                this.processFileSet(fileSet);
            }
        } else if (this.sourceDir == null) {
            this.getLog().warn((CharSequence)"no sourceDir");
        } else if (this.sourceDir.isDirectory() && this.sourceDir.list().length > 0) {
            FileSet fs = new FileSet();
            fs.setDirectory(this.sourceDir.getPath());
            fs.addInclude("**/*.java");
            this.processFileSet(fs);
        } else {
            this.getLog().warn((CharSequence)("empty sourceDir " + this.sourceDir.getAbsolutePath()));
        }
        this.finishExecute();
        if (this.processors != null) {
            for (AbstractTentackleProcessor processor : this.processors) {
                try {
                    processor.cleanup();
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"annotation processor cleanup failed", (Throwable)ex);
                    ++this.totalErrors;
                }
            }
        }
        if (this.totalErrors > 0) {
            throw new MojoFailureException(this.totalErrors + " wurbel errors");
        }
    }

    @Override
    protected void validate() throws MojoExecutionException {
        super.validate();
        if (this.sourceDir == null) {
            throw new MojoExecutionException("missing tentackle.sourceDir");
        }
    }

    protected void initializeProcessor(AbstractTentackleProcessor processor, File srcDir) throws MojoFailureException {
        processor.setSourceDir(srcDir);
    }

    protected void initializeProcessors(File srcDir) throws MojoFailureException {
        if (this.processors != null) {
            for (AbstractTentackleProcessor processor : this.processors) {
                this.initializeProcessor(processor, srcDir);
            }
        }
    }

    protected void cleanupProcessors(File srcDir) throws MojoFailureException {
    }

    protected String[] filterFileNames(String dirName, String[] fileNames) {
        return fileNames;
    }

    private void processFileSet(FileSet fileSet) throws MojoFailureException, MojoExecutionException {
        if (fileSet.getDirectory() == null && this.sourceDir != null) {
            fileSet.setDirectory(this.sourceDir.getAbsolutePath());
        }
        File dir = new File(fileSet.getDirectory());
        this.initializeProcessors(dir);
        String dirName = this.getCanonicalPath(dir);
        if (this.verbosityLevel.isDebug()) {
            this.getLog().info((CharSequence)("analyzing files in " + dirName));
        }
        int errorCount = 0;
        int compileErrorCount = 0;
        String[] fileNames = new FileSetManager(this.getLog(), this.verbosityLevel.isDebug()).getIncludedFiles(fileSet);
        if ((fileNames = this.filterFileNames(dirName, fileNames)).length > 0) {
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = dirName + "/" + fileNames[i];
                if (!this.verbosityLevel.isDebug()) continue;
                this.getLog().info((CharSequence)("analyzing " + fileNames[i]));
            }
            JavacTool compiler = JavacTool.create();
            if (compiler == null) {
                throw new MojoExecutionException("No Java compiler! Make sure you're using the JDK or tools.jar is in your classpath.");
            }
            DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticCollector, null, null);
            ArrayList<String> options = new ArrayList<String>();
            options.add("-encoding");
            options.add(this.encoding);
            options.add("-proc:only");
            options.add("-classpath");
            StringBuilder buf = new StringBuilder();
            if (this.classpathElements != null) {
                for (String element : this.classpathElements) {
                    if (buf.length() > 0) {
                        buf.append(File.pathSeparatorChar);
                    }
                    buf.append(element);
                }
            }
            options.add(buf.toString());
            options.add("-Averbosity=" + this.verbosityLevel);
            JavaCompiler.CompilationTask task = compiler.getTask(null, (JavaFileManager)fileManager, diagnosticCollector, options, null, fileManager.getJavaFileObjects(fileNames));
            if (this.processors != null) {
                task.setProcessors(this.processors);
            } else {
                this.getLog().warn((CharSequence)"no annotation processors defined");
            }
            task.call();
            for (Diagnostic diag : diagnosticCollector.getDiagnostics()) {
                if (this.showCompileOutput) {
                    JavaFileObject source = (JavaFileObject)diag.getSource();
                    if (source == null) {
                        this.getLog().info((CharSequence)diag.getMessage(null));
                    } else {
                        String filename = source.getName();
                        int ndx = filename.lastIndexOf(File.separatorChar);
                        if (ndx > 0) {
                            filename = filename.substring(ndx + 1);
                        }
                        this.getLog().info((CharSequence)(filename + ":" + diag.getLineNumber() + ":" + diag.getColumnNumber() + ": " + diag.getMessage(null)));
                    }
                }
                if (diag.getKind() != Diagnostic.Kind.ERROR) continue;
                ++compileErrorCount;
            }
        }
        this.cleanupProcessors(dir);
        this.getLog().info((CharSequence)(this.getPathRelativeToBasedir(dirName) + ": " + fileNames.length + " files analyzed, " + errorCount + " errors"));
        if (compileErrorCount > 0) {
            this.getLog().warn((CharSequence)(compileErrorCount + " Java compilation errors! Some annotations may have been processed improperly or not processed at all"));
        }
        this.totalErrors += errorCount;
    }
}

