/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.buildsupport.ResourceManager;
import org.tentackle.maven.AbstractTentackleAnnotationProcessingMojo;

public abstract class AbstractAnalyzeAnnotationProcessingMojo
extends AbstractTentackleAnnotationProcessingMojo {
    private File analyzeDir;
    private File servicesDir;
    @Parameter
    protected String index;
    private Set<String> generatedServices;
    private final long startedMillis;

    public AbstractAnalyzeAnnotationProcessingMojo() {
        this.addProcessor((AbstractTentackleProcessor)new AnalyzeProcessor());
        this.startedMillis = System.currentTimeMillis();
    }

    public void setMojoParameters(File sourceDir, File analyzeDir, File servicesDir, List<String> classpathElements) throws MojoFailureException {
        super.setMojoParameters(sourceDir, classpathElements);
        this.analyzeDir = analyzeDir;
        this.servicesDir = servicesDir;
    }

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.analyzeDir == null) {
                throw new MojoExecutionException("missing tentackle.analyzeDir");
            }
            if (this.analyzeDir.getPath().contains("${")) {
                throw new MojoExecutionException("undefined variable(s) in analyzeDir: " + this.analyzeDir.getPath());
            }
            if (this.servicesDir == null) {
                throw new MojoExecutionException("missing tentackle.serviceDir");
            }
            if (this.servicesDir.getPath().contains("${")) {
                throw new MojoExecutionException("undefined variable(s) in servicesDir: " + this.servicesDir.getPath());
            }
            return true;
        }
        return false;
    }

    protected void createMissingDirs() {
        super.createMissingDirs();
        this.analyzeDir.mkdirs();
        this.servicesDir.mkdirs();
    }

    protected void initializeProcessor(AbstractTentackleProcessor processor, File srcDir) throws MojoFailureException {
        super.initializeProcessor(processor, srcDir);
        AnalyzeProcessor p = (AnalyzeProcessor)processor;
        p.setAnalyzeDir(this.analyzeDir);
        p.setServiceDir(this.servicesDir);
        p.setProcessingClassLoader(this.getProcessingClassloader());
    }

    protected void cleanupProcessors(File srcDir) throws MojoFailureException {
        if (this.index != null && this.processors != null) {
            if (this.generatedServices == null) {
                this.generatedServices = new TreeSet<String>();
            }
            for (AbstractTentackleProcessor processor : this.processors) {
                for (ResourceManager rm : processor.getResourceManagers()) {
                    if (!rm.getLocation().equals(this.servicesDir)) continue;
                    this.generatedServices.addAll(rm.getResourceNames());
                }
            }
        }
        super.cleanupProcessors(srcDir);
    }

    protected String[] filterFileNames(String dirName, String[] fileNames) {
        ArrayList<String> filteredNames = new ArrayList<String>();
        for (String fileName : fileNames) {
            String sourceFilePath = dirName + File.separator + fileName;
            long sourceLastModified = new File(sourceFilePath).lastModified();
            Object outputDirPath = this.analyzeDir.getAbsolutePath() + File.separator + fileName;
            int ndx = ((String)outputDirPath).lastIndexOf(46);
            if (ndx > 0) {
                outputDirPath = ((String)outputDirPath).substring(0, ndx);
            }
            long minOutputLastModified = 0L;
            File outputDir = new File((String)outputDirPath);
            if (outputDir.exists()) {
                long lastModified = outputDir.lastModified();
                if (lastModified < this.startedMillis) {
                    minOutputLastModified = lastModified;
                    File[] files = outputDir.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            lastModified = file.lastModified();
                            if (lastModified >= minOutputLastModified) continue;
                            minOutputLastModified = lastModified;
                        }
                    }
                }
            } else {
                outputDir.mkdirs();
            }
            if (minOutputLastModified < sourceLastModified) {
                filteredNames.add(fileName);
                continue;
            }
            if (!this.verbosityLevel.isDebug()) continue;
            this.getLog().info((CharSequence)("skipped unchanged " + sourceFilePath));
        }
        return filteredNames.toArray(new String[0]);
    }

    public void finishExecute() throws MojoExecutionException, MojoFailureException {
        PrintWriter writer;
        if (this.index != null && this.generatedServices != null && !this.generatedServices.isEmpty()) {
            try {
                writer = new ResourceManager(this.servicesDir).getWriter(this.index);
                try {
                    for (String generatedService : this.generatedServices) {
                        writer.println(generatedService);
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException ix) {
                throw new MojoFailureException("cannot create resource index", (Throwable)ix);
            }
        }
        if (this.getTotalCompileErrors() > 0) {
            try {
                writer = new ResourceManager(this.analyzeDir).getWriter("error.log");
                try {
                    writer.print(this.getCompileErrorLog());
                    writer.print(this.getTotalCompileErrors());
                    writer.println(" compilation errors");
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException ix) {
                throw new MojoFailureException("cannot create compiler error log", (Throwable)ix);
            }
        }
        super.finishExecute();
    }
}

