/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class ToolRunner {
    private final File tool;
    private final List<String> command;
    private List<String> output;
    private List<String> errors;
    private int errCode;

    public ToolRunner(File tool) throws MojoExecutionException {
        this.tool = tool;
        if (!tool.isFile()) {
            throw new MojoExecutionException(tool + " not found");
        }
        if (!tool.canExecute()) {
            throw new MojoExecutionException(tool + " is not executable");
        }
        this.command = new ArrayList<String>();
        this.arg(tool);
    }

    public ToolRunner arg(Object ... args) {
        for (Object arg : args) {
            this.command.add(arg.toString());
        }
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean needSep = false;
        for (String arg : this.command) {
            if (needSep) {
                buf.append(' ');
            } else {
                needSep = true;
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public ToolRunner run() throws MojoExecutionException {
        try {
            Process process = new ProcessBuilder(this.command).start();
            this.errCode = process.waitFor();
            this.output = ToolRunner.collect(process.getInputStream());
            this.errors = ToolRunner.collect(process.getErrorStream());
            return this;
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("running tool " + this.tool + " failed", e);
        }
    }

    public List<String> getOutput() throws MojoExecutionException {
        this.assertExecuted();
        return this.output;
    }

    public String getOutputAsString() throws MojoExecutionException {
        return this.linesToString(this.getOutput());
    }

    public List<String> getErrors() throws MojoExecutionException {
        this.assertExecuted();
        return this.errors;
    }

    public String getErrorsAsString() throws MojoExecutionException {
        return this.linesToString(this.getErrors());
    }

    public int getErrCode() throws MojoExecutionException {
        this.assertExecuted();
        return this.errCode;
    }

    public void clear() {
        this.command.clear();
        this.arg(this.tool);
        this.errCode = 0;
        this.output = null;
        this.errors = null;
    }

    private static List<String> collect(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    private void assertExecuted() throws MojoExecutionException {
        if (this.output == null) {
            throw new MojoExecutionException("run() method must be invoked first");
        }
    }

    private String linesToString(List<String> lines) {
        StringBuilder buf = new StringBuilder();
        boolean needNl = false;
        for (String line : lines) {
            if (needNl) {
                buf.append('\n');
            } else {
                needNl = true;
            }
            buf.append(line);
        }
        return buf.toString();
    }
}

