/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.tentackle.common.Settings;
import org.tentackle.maven.ToolFinder;
import org.wurbelizer.misc.Verbosity;

public abstract class AbstractTentackleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${settings}", readonly=true)
    private org.apache.maven.settings.Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${tentackle.verbosity}")
    protected String verbosity;
    @Parameter
    private Boolean skip;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String charset;
    protected Verbosity verbosityLevel;
    protected List<String> resourceDirs;
    private ToolFinder toolFinder;

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public org.apache.maven.settings.Settings getSettings() {
        return this.settings;
    }

    public SettingsDecrypter getSettingsDecrypter() {
        return this.settingsDecrypter;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public Toolchain getToolChain() {
        Toolchain toolChain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolChain != null) {
            this.getLog().debug((CharSequence)("using toolchain " + toolChain));
        }
        return toolChain;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.prepareExecute();
        if (this.validate()) {
            this.executeImpl();
            this.finishExecute();
        }
    }

    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
    }

    public abstract void executeImpl() throws MojoExecutionException, MojoFailureException;

    public void finishExecute() throws MojoExecutionException, MojoFailureException {
    }

    public void determineEncoding() {
        if (this.charset != null) {
            Charset cs = Charset.forName(this.charset);
            Settings.setEncodingCharset((Charset)cs);
            org.wurbelizer.misc.Settings.setEncodingCharset((Charset)cs);
        }
    }

    public void determineVerbosity() {
        if (this.verbosity != null) {
            try {
                this.verbosityLevel = Verbosity.valueOf((String)this.verbosity.toUpperCase());
            }
            catch (RuntimeException ex) {
                this.verbosityLevel = Verbosity.DEFAULT;
            }
        } else {
            this.verbosityLevel = this.getLog().isDebugEnabled() ? Verbosity.DEBUG : Verbosity.DEFAULT;
        }
    }

    public String getPathRelativeToBasedir(String path) {
        String basePath = this.mavenProject.getBasedir().getAbsolutePath();
        while (basePath.length() > 0) {
            if (path.startsWith(basePath)) {
                int len = basePath.lastIndexOf(File.separatorChar);
                len = len > 0 ? ++len : basePath.length() + 1;
                return path.substring(len);
            }
            int ndx = basePath.lastIndexOf(File.separatorChar);
            if (ndx <= 0) break;
            basePath = basePath.substring(0, ndx);
        }
        return path;
    }

    public void findResourceDirs() {
        this.resourceDirs = new ArrayList<String>();
        for (Object resource : this.mavenProject.getBuild().getResources()) {
            String name;
            if (!(resource instanceof Resource) || (name = ((Resource)resource).getDirectory()) == null) continue;
            this.getLog().debug((CharSequence)("found resource directory " + name));
            this.resourceDirs.add(name);
        }
    }

    public String getResourceDirName(String dirName) {
        if (this.resourceDirs != null) {
            for (String resourceDir : this.resourceDirs) {
                if (!dirName.startsWith(resourceDir)) continue;
                return resourceDir;
            }
        }
        return null;
    }

    public String getCanonicalPath(File dir) throws MojoExecutionException {
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("cannot determine canonical path of " + dir, (Exception)ex);
        }
    }

    public ToolFinder getToolFinder() {
        if (this.toolFinder == null) {
            this.toolFinder = new ToolFinder(this.getToolChain());
        }
        return this.toolFinder;
    }

    public String loadResourceFileIntoString(String path) throws MojoExecutionException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (inputStream == null) {
            throw new MojoExecutionException("no such resource: " + path);
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
        return buffer.lines().collect(Collectors.joining(System.getProperty("line.separator")));
    }

    protected boolean isExecutionRecursive() {
        return this.mavenSession.getRequest().isRecursive() && !this.mojoExecution.getMojoDescriptor().isAggregator();
    }

    protected boolean isSkippedByDefault() {
        return "pom".equals(this.mavenProject.getPackaging()) && this.isExecutionRecursive();
    }

    protected boolean validate() throws MojoExecutionException {
        this.determineEncoding();
        this.determineVerbosity();
        if (this.mavenProject.getBasedir() == null) {
            throw new MojoExecutionException("missing project.baseDir");
        }
        if (this.skip == null && this.isSkippedByDefault()) {
            this.skip = true;
        }
        if (Boolean.TRUE.equals(this.skip)) {
            this.getLog().info((CharSequence)"skipped");
            return false;
        }
        return true;
    }
}

