/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.ProjectClassLoader;

public abstract class AbstractTentackleAnnotationProcessingMojo
extends AbstractTentackleMojo {
    @Parameter(defaultValue="${tentackle.showCompileOutput}")
    protected boolean showCompileOutput;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected List<String> compilerArgs;
    @Parameter
    protected String compilerArgument;
    @Parameter
    protected List<FileSet> filesets;
    private File sourceDir;
    private List<String> classpathElements;
    private int totalErrors;
    protected List<AbstractTentackleProcessor> processors;
    private ClassLoader processingClassloader;
    private int totalCompileErrors;
    private StringBuilder compileErrorLog;

    public void setMojoParameters(File sourceDir, List<String> classpathElements) throws MojoFailureException {
        this.sourceDir = sourceDir;
        this.classpathElements = classpathElements;
        try {
            this.processingClassloader = new ProjectClassLoader((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader(), classpathElements);
        }
        catch (MalformedURLException mx) {
            throw new MojoFailureException("cannot create project classloader", (Throwable)mx);
        }
    }

    public ClassLoader getProcessingClassloader() {
        return this.processingClassloader;
    }

    public void addProcessor(AbstractTentackleProcessor processor) {
        if (this.processors == null) {
            this.processors = new ArrayList<AbstractTentackleProcessor>();
        }
        this.processors.add(processor);
    }

    protected void createMissingDirs() {
    }

    public int getTotalCompileErrors() {
        return this.totalCompileErrors;
    }

    public String getCompileErrorLog() {
        return this.compileErrorLog == null ? "" : this.compileErrorLog.toString();
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.createMissingDirs();
        this.totalErrors = 0;
        this.totalCompileErrors = 0;
        this.compileErrorLog = new StringBuilder();
        if (this.filesets != null && !this.filesets.isEmpty()) {
            for (FileSet fileSet : this.filesets) {
                this.processFileSet(fileSet);
            }
        } else if (this.sourceDir == null) {
            this.getLog().warn((CharSequence)"no sourceDir configured");
        } else {
            String[] files;
            String[] stringArray = files = this.sourceDir.isDirectory() ? this.sourceDir.list() : null;
            if (files != null && files.length > 0) {
                FileSet fs = new FileSet();
                fs.setDirectory(this.sourceDir.getPath());
                fs.addInclude("**/*.java");
                this.processFileSet(fs);
            } else {
                this.getLog().info((CharSequence)((this.sourceDir.exists() ? "empty" : "missing") + " source directory " + this.sourceDir.getAbsolutePath()));
            }
        }
        if (this.processors != null) {
            for (AbstractTentackleProcessor processor : this.processors) {
                try {
                    processor.cleanup();
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"annotation processor cleanup failed", (Throwable)ex);
                    ++this.totalErrors;
                }
            }
        }
        if (this.totalErrors > 0) {
            throw new MojoFailureException(this.totalErrors + " analyze errors");
        }
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.sourceDir == null) {
                throw new MojoExecutionException("missing tentackle.sourceDir");
            }
            return true;
        }
        return false;
    }

    protected void initializeProcessor(AbstractTentackleProcessor processor, File srcDir) throws MojoFailureException {
        processor.setSourceDir(srcDir);
    }

    protected void initializeProcessors(File srcDir) throws MojoFailureException {
        if (this.processors != null) {
            for (AbstractTentackleProcessor processor : this.processors) {
                this.initializeProcessor(processor, srcDir);
            }
        }
    }

    protected void cleanupProcessors(File srcDir) throws MojoFailureException {
    }

    protected String[] filterFileNames(String dirName, String[] fileNames) {
        return fileNames;
    }

    private void processFileSet(FileSet fileSet) throws MojoFailureException, MojoExecutionException {
        if (fileSet.getDirectory() == null) {
            if (this.sourceDir == null) {
                throw new MojoExecutionException("no sourceDir configured");
            }
            fileSet.setDirectory(this.sourceDir.getAbsolutePath());
        }
        File dir = new File(fileSet.getDirectory());
        this.initializeProcessors(dir);
        String dirName = this.getCanonicalPath(dir);
        if (this.verbosityLevel.isDebug()) {
            this.getLog().info((CharSequence)("analyzing files in " + dirName));
        }
        int errorCount = 0;
        int compileErrorCount = 0;
        String[] fileNames = new FileSetManager(this.getLog(), this.verbosityLevel.isDebug()).getIncludedFiles(fileSet);
        if ((fileNames = this.filterFileNames(dirName, fileNames)).length > 0) {
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = dirName + "/" + fileNames[i];
                if (!this.verbosityLevel.isDebug()) continue;
                this.getLog().info((CharSequence)("analyzing " + fileNames[i]));
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new MojoExecutionException("No Java compiler! jdk.compiler in module path?");
            }
            DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticCollector, null, null);
            ArrayList<String> options = new ArrayList<String>();
            options.add("-encoding");
            options.add(this.encoding);
            if (this.classpathElements != null && !this.classpathElements.isEmpty()) {
                options.add("-classpath");
                StringBuilder buf = new StringBuilder();
                for (String element : this.classpathElements) {
                    if (buf.length() > 0) {
                        buf.append(File.pathSeparatorChar);
                    }
                    buf.append(element);
                }
                options.add(buf.toString());
                options.add("--module-path");
                options.add(buf.toString());
            }
            options.add("-Averbosity=" + this.verbosityLevel);
            if (this.compilerArgument != null && !this.compilerArgument.isEmpty()) {
                options.add(this.compilerArgument);
            }
            boolean procFound = false;
            if (this.compilerArgs != null) {
                for (String arg : this.compilerArgs) {
                    options.add(arg);
                    if (!arg.startsWith("proc:")) continue;
                    procFound = true;
                }
            }
            if (!procFound) {
                options.add("-proc:only");
            }
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticCollector, options, null, fileManager.getJavaFileObjects(fileNames));
            if (this.processors != null) {
                task.setProcessors(this.processors);
            } else {
                this.getLog().warn((CharSequence)"no annotation processors defined");
            }
            task.call();
            for (Diagnostic diag : diagnosticCollector.getDiagnostics()) {
                if (this.showCompileOutput) {
                    Object msg;
                    JavaFileObject source = (JavaFileObject)diag.getSource();
                    if (source == null) {
                        msg = diag.getMessage(null);
                    } else {
                        String filename = source.getName();
                        int ndx = filename.lastIndexOf(File.separatorChar);
                        if (ndx > 0) {
                            filename = filename.substring(ndx + 1);
                        }
                        msg = filename + ":" + diag.getLineNumber() + ":" + diag.getColumnNumber() + ": " + diag.getMessage(null);
                    }
                    this.getLog().info((CharSequence)msg);
                    this.compileErrorLog.append((String)msg).append('\n');
                }
                if (diag.getKind() != Diagnostic.Kind.ERROR) continue;
                ++compileErrorCount;
            }
        }
        this.cleanupProcessors(dir);
        this.getLog().info((CharSequence)(this.getPathRelativeToBasedir(dirName) + ": " + fileNames.length + " files analyzed, " + errorCount + " errors"));
        if (compileErrorCount > 0) {
            this.getLog().warn((CharSequence)(compileErrorCount + " Java compilation errors! Some annotations may have been processed improperly or not processed at all"));
        }
        this.totalCompileErrors += compileErrorCount;
        this.totalErrors += errorCount;
    }
}

