/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.maven.plugin.logging.Log;

public class MavenLogHandler
extends Handler {
    private final Log log;
    private final Level minLevel;

    public MavenLogHandler(Log log, Level minLevel) {
        this.log = Objects.requireNonNull(log);
        this.minLevel = Objects.requireNonNull(minLevel);
    }

    @Override
    public void publish(LogRecord record) {
        if (record != null && record.getLevel().intValue() >= this.minLevel.intValue()) {
            if (record.getLevel() == Level.SEVERE) {
                this.log.error((CharSequence)record.getMessage(), record.getThrown());
            } else if (record.getLevel() == Level.WARNING) {
                this.log.warn((CharSequence)record.getMessage(), record.getThrown());
            } else if (record.getLevel() == Level.INFO) {
                this.log.info((CharSequence)record.getMessage(), record.getThrown());
            } else {
                this.log.debug((CharSequence)record.getMessage(), record.getThrown());
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

