/*
 * Tentackle - https://tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.tentackle.maven;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import org.apache.maven.plugin.logging.Log;

import java.io.File;
import java.io.IOException;

/**
 * Base class for generators.
 */
public class AbstractGenerator {

  private File templateDirectory;
  private Log logger;

  /**
   * Gets the freemarker template directory.
   *
   * @return the template directory
   */
  public File getTemplateDirectory() {
    return templateDirectory;
  }

  /**
   * Sets the freemarker template directory.
   *
   * @param templateDirectory the template directory
   */
  public void setTemplateDirectory(File templateDirectory) {
    this.templateDirectory = templateDirectory;
  }

  /**
   * Gets the maven logger.
   *
   * @return the logger
   */
  public Log getLogger() {
    return logger;
  }

  /**
   * Sets the maven logger.
   *
   * @param logger the logger
   */
  public void setLogger(Log logger) {
    this.logger = logger;
  }

  /**
   * Creates the freemarker configuration.
   *
   * @return the config
   * @throws IOException if there's some trouble with the template directory
   */
  public Configuration createFreemarkerConfiguration() throws IOException {
    Configuration cfg = new Configuration(Configuration.VERSION_2_3_31);
    cfg.setDirectoryForTemplateLoading(templateDirectory);
    cfg.setDefaultEncoding("UTF-8");
    cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    cfg.setLogTemplateExceptions(false);
    cfg.setWrapUncheckedExceptions(true);
    return cfg;
  }

}
