/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.File;
import java.util.Optional;
import org.apache.maven.toolchain.Toolchain;
import org.tentackle.common.ToolFinder;

public class JavaToolFinder
extends ToolFinder {
    private final Toolchain toolchain;

    public JavaToolFinder(Toolchain toolchain) {
        this.toolchain = toolchain;
    }

    public JavaToolFinder() {
        this(null);
    }

    public File find(String toolName) {
        String fileName;
        File file = null;
        if (this.toolchain != null && (fileName = this.toolchain.findTool(toolName)) != null) {
            file = new File(fileName);
        }
        if (file == null) {
            String javaHomeEnv;
            File toolDir = this.locateJavaToolDir();
            if (toolDir != null) {
                file = this.loadTool(toolDir, toolName);
            }
            if (file == null && (javaHomeEnv = System.getenv("JAVA_HOME")) != null) {
                toolDir = new File(javaHomeEnv, "bin");
                file = this.loadTool(toolDir, toolName);
            }
            if (file == null) {
                file = super.find(toolName);
            }
        }
        return file;
    }

    private File locateJavaToolDir() {
        File toolDir = null;
        Optional<String> javaCommand = ProcessHandle.current().info().command();
        if (javaCommand.isPresent()) {
            toolDir = new File(javaCommand.get()).getParentFile();
        }
        return toolDir;
    }
}

