/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.maven.plugin.logging.Log;

public class MavenLogHandler
extends Handler {
    private final Log log;
    private final Level minLevel;

    public MavenLogHandler(Log log, Level minLevel) {
        this.log = Objects.requireNonNull(log);
        this.minLevel = Objects.requireNonNull(minLevel);
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord != null && logRecord.getLevel().intValue() >= this.minLevel.intValue()) {
            if (logRecord.getLevel() == Level.SEVERE) {
                this.log.error((CharSequence)logRecord.getMessage(), logRecord.getThrown());
            } else if (logRecord.getLevel() == Level.WARNING) {
                this.log.warn((CharSequence)logRecord.getMessage(), logRecord.getThrown());
            } else if (logRecord.getLevel() == Level.INFO) {
                this.log.info((CharSequence)logRecord.getMessage(), logRecord.getThrown());
            } else {
                this.log.debug((CharSequence)logRecord.getMessage(), logRecord.getThrown());
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

