/*
 * Tentackle - https://tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.tentackle.maven;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;

import org.tentackle.common.Settings;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/**
 * File to be generated by freemarker.
 */
public class GeneratedFile {

  private final Configuration cfg;
  @SuppressWarnings("rawtypes")
  private final Map model;
  private final String templateName;
  private final File outputFile;

  /**
   * Creates a file generator.
   *
   * @param cfg the freemarker configuration
   * @param model the freemarker model
   * @param templateName the name of the freemarker template
   * @param outputFile the output file
   */
  @SuppressWarnings("rawtypes")
  public GeneratedFile(Configuration cfg, Map model, String templateName, File outputFile) {
    this.cfg = cfg;
    this.model = model;
    this.templateName = templateName;
    this.outputFile = outputFile;
  }

  /**
   * Generates the file.
   *
   * @throws IOException if writing to file failed
   * @throws TemplateException if some template error
   */
  public void generate() throws IOException, TemplateException {
    try (Writer writer = new FileWriter(outputFile, Settings.getEncodingCharset())) {
      cfg.getTemplate(templateName).process(model, writer);
    }
  }
}
