/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.slf4j.LoggerFactory;
import org.tentackle.common.Settings;
import org.tentackle.common.ToolRunner;
import org.tentackle.maven.JavaToolFinder;
import org.tentackle.maven.MavenLogHandler;
import org.tentackle.maven.PackageInfo;
import org.wurbelizer.misc.Verbosity;

public abstract class AbstractTentackleMojo
extends AbstractMojo {
    public static final String JDK_TOOLCHAIN = "jdk";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${settings}", readonly=true)
    private org.apache.maven.settings.Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${tentackle.verbosity}")
    protected String verbosity;
    @Parameter
    private Boolean skip;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String charset;
    @Parameter(defaultValue="WARNING")
    protected String minLogLevel;
    protected Verbosity verbosityLevel;
    private List<String> resourceDirs;
    private List<String> testResourceDirs;
    private JavaToolFinder toolFinder;

    public void installJavaLoggingHandler() {
        LogManager.getLogManager().reset();
        LogManager.getLogManager().getLogger("").addHandler(new MavenLogHandler(this.getLog(), Level.parse(this.minLogLevel)));
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public org.apache.maven.settings.Settings getSettings() {
        return this.settings;
    }

    public SettingsDecrypter getSettingsDecrypter() {
        return this.settingsDecrypter;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public Toolchain getToolchain() throws MojoExecutionException {
        return this.getToolchain(JDK_TOOLCHAIN);
    }

    public Toolchain getToolchain(String type, Map<String, String> selector) throws MojoExecutionException {
        try {
            Method method = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
            List toolchains = (List)method.invoke((Object)this.toolchainManager, this.mavenSession, type, selector);
            return toolchains != null && !toolchains.isEmpty() ? (Toolchain)toolchains.get(0) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MojoExecutionException("loading toolchain failed for type=" + type + ", selector=" + String.valueOf(selector), e);
        }
    }

    public Toolchain getToolchain(String type) throws MojoExecutionException {
        Toolchain toolchain;
        if (this.jdkToolchain != null) {
            if (this.jdkToolchain.isEmpty()) {
                toolchain = null;
            } else {
                toolchain = this.getToolchain(type, this.jdkToolchain);
                if (toolchain == null) {
                    throw new MojoExecutionException("no matching '" + type + "' toolchain for: " + String.valueOf(this.jdkToolchain));
                }
            }
        } else {
            toolchain = this.toolchainManager.getToolchainFromBuildContext(type, this.mavenSession);
        }
        if (this.getLog().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("using ");
            if (toolchain == null) {
                buf.append("no ");
            }
            buf.append("toolchain for type ").append(type);
            if (toolchain != null) {
                buf.append(": ").append(toolchain);
            }
            this.getLog().debug((CharSequence)buf);
        }
        return toolchain;
    }

    public File getJavaHome(Toolchain toolchain) throws MojoExecutionException {
        DefaultJavaToolChain defaultJavaToolChain;
        String javaHome;
        if (toolchain instanceof DefaultJavaToolChain && (javaHome = (defaultJavaToolChain = (DefaultJavaToolChain)toolchain).getJavaHome()) != null && !javaHome.isBlank()) {
            File javaHomeDir = new File(javaHome);
            if (javaHomeDir.isDirectory()) {
                return javaHomeDir;
            }
            throw new MojoExecutionException("JAVA_HOME=" + javaHomeDir.getAbsolutePath() + " given by toolchain " + toolchain.getType() + " does not exist or is not a directory");
        }
        return null;
    }

    public String getHostName() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            hostName = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return hostName;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.installJavaLoggingHandler();
        this.prepareExecute();
        if (this.validate()) {
            this.executeImpl();
            this.finishExecute();
        }
    }

    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
    }

    public abstract void executeImpl() throws MojoExecutionException, MojoFailureException;

    public void finishExecute() throws MojoExecutionException, MojoFailureException {
    }

    public void determineEncoding() {
        if (this.charset != null) {
            Charset cs = Charset.forName(this.charset);
            Settings.setEncodingCharset((Charset)cs);
            org.wurbelizer.misc.Settings.setEncodingCharset((Charset)cs);
        }
    }

    public void determineVerbosity() {
        if (this.verbosity != null) {
            try {
                this.verbosityLevel = Verbosity.valueOf((String)this.verbosity.toUpperCase(Locale.ROOT));
            }
            catch (RuntimeException ex) {
                this.verbosityLevel = Verbosity.DEFAULT;
            }
        } else {
            this.verbosityLevel = this.getLog().isDebugEnabled() ? Verbosity.DEBUG : Verbosity.DEFAULT;
        }
    }

    public String getPathRelativeToBasedir(String path) {
        String basePath = this.mavenProject.getBasedir().getAbsolutePath();
        while (!basePath.isEmpty()) {
            if (path.startsWith(basePath)) {
                int len = basePath.lastIndexOf(File.separatorChar);
                len = len > 0 ? ++len : basePath.length() + 1;
                return path.substring(len);
            }
            int ndx = basePath.lastIndexOf(File.separatorChar);
            if (ndx <= 0) break;
            basePath = basePath.substring(0, ndx);
        }
        return path;
    }

    public List<String> getResourceDirs(boolean test) {
        if (test && this.testResourceDirs == null || !test && this.resourceDirs == null) {
            ArrayList<String> dirs = new ArrayList<String>();
            List resources = test ? this.mavenProject.getBuild().getTestResources() : this.mavenProject.getBuild().getResources();
            for (Resource resource : resources) {
                String name;
                if (resource == null || (name = resource.getDirectory()) == null) continue;
                this.getLog().debug((CharSequence)("found resource directory " + name));
                dirs.add(name);
            }
            if (test) {
                this.testResourceDirs = dirs;
            } else {
                this.resourceDirs = dirs;
            }
        }
        return test ? this.testResourceDirs : this.resourceDirs;
    }

    public File getResourceDir(File file, boolean test) throws MojoExecutionException {
        String filePath = this.getCanonicalPath(file);
        for (String resourceDirName : this.getResourceDirs(test)) {
            File resourceDir = new File(resourceDirName);
            String resourceDirPath = this.getCanonicalPath(resourceDir);
            if (!filePath.startsWith(resourceDirPath)) continue;
            return resourceDir;
        }
        return null;
    }

    public String getCanonicalPath(File dir) throws MojoExecutionException {
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("cannot determine canonical path of " + String.valueOf(dir), (Exception)ex);
        }
    }

    public JavaToolFinder getToolFinder() throws MojoExecutionException {
        if (this.toolFinder == null) {
            this.toolFinder = new JavaToolFinder(this.getToolchain());
        }
        return this.toolFinder;
    }

    public String determineJavaToolVersion(File javaTool) throws MojoExecutionException {
        String output = new ToolRunner(javaTool).arg(new Object[]{"--version"}).run().getOutputAsString();
        StringTokenizer stok = new StringTokenizer(output);
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (!Character.isDigit(token.charAt(0)) || token.length() != 2 && (token.length() <= 2 || token.charAt(2) != '.' && token.charAt(2) != '-')) continue;
            return token;
        }
        throw new MojoExecutionException("cannot determine version string from tool's output:\n" + output);
    }

    public int getMajorVersion(String version) {
        int ndx = version.indexOf(46);
        if (ndx < 0) {
            ndx = version.indexOf(45);
        }
        return Integer.parseInt(ndx >= 0 ? version.substring(0, ndx) : version);
    }

    public String loadResourceFileIntoString(String path) throws MojoExecutionException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (inputStream == null) {
            throw new MojoExecutionException("no such resource: " + path);
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
        return buffer.lines().collect(Collectors.joining(System.getProperty("line.separator")));
    }

    public String toDescriptorName(File file) {
        String name = file.getName();
        int ndx = name.lastIndexOf(46);
        if (ndx > 0 && ndx < name.length() - 1 && !Character.isDigit(name.charAt(ndx + 1))) {
            name = name.substring(0, ndx);
        }
        StringBuilder buf = new StringBuilder();
        StringTokenizer stok = new StringTokenizer(name, "-");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (token.isBlank() || "SNAPSHOT".equals(token)) continue;
            if (!buf.isEmpty()) {
                if (Character.isDigit(token.charAt(0))) break;
                buf.append('-');
            }
            buf.append(token);
        }
        if ((name = buf.toString()).startsWith(".")) {
            name = name.substring(1);
        }
        return name;
    }

    public FileSetManager createFileSetManager(boolean verbose) {
        return new FileSetManager(LoggerFactory.getLogger(FileSetManager.class), verbose);
    }

    public String[] getIncludedFiles(FileSet fileSet) {
        return this.createFileSetManager(this.verbosityLevel.isDebug()).getIncludedFiles(fileSet);
    }

    protected boolean isExecutionRecursive() {
        return this.mavenSession.getRequest().isRecursive() && !this.mojoExecution.getMojoDescriptor().isAggregator();
    }

    protected boolean isSkippedByDefault() {
        return "pom".equals(this.mavenProject.getPackaging()) && this.isExecutionRecursive();
    }

    protected boolean validate() throws MojoExecutionException {
        this.determineEncoding();
        this.determineVerbosity();
        if (this.mavenProject.getBasedir() == null) {
            throw new MojoExecutionException("missing project.baseDir");
        }
        if (this.skip == null && this.isSkippedByDefault()) {
            this.skip = true;
        }
        if (Boolean.TRUE.equals(this.skip)) {
            this.getLog().info((CharSequence)"skipped");
            return false;
        }
        return true;
    }

    protected Map<String, PackageInfo> createPackageMap(boolean resourceRoots) throws MojoExecutionException {
        List<MavenProject> projects;
        HashMap<String, PackageInfo> map = new HashMap<String, PackageInfo>();
        StringBuilder buf = new StringBuilder();
        if (this.isExecutionRecursive()) {
            projects = new ArrayList();
            projects.add(this.mavenProject);
        } else {
            projects = this.mavenProject.getCollectedProjects();
        }
        for (MavenProject project : projects) {
            List<String> paths = resourceRoots ? project.getResources().stream().filter(resource -> !resource.isFiltering()).map(resource -> resource.getDirectory()).toList() : project.getCompileSourceRoots();
            for (String path : paths) {
                for (PackageInfo info : this.getPackages(project, path)) {
                    boolean infoContainingFiles = info.isContainingFiles();
                    PackageInfo splitPkg = (PackageInfo)map.get(info.getName());
                    if (splitPkg != null) {
                        if (splitPkg.isContainingFiles()) {
                            if (!infoContainingFiles) continue;
                            buf.append("\nsplit package detected: ").append(info.getName()).append(" in ").append(project.getName()).append(" and ").append(splitPkg.getProject().getName());
                            continue;
                        }
                        if (!infoContainingFiles) {
                            List<PackageInfo> dups = splitPkg.getEmptyDuplicates();
                            if (dups == null) {
                                dups = new ArrayList<PackageInfo>();
                                splitPkg.setEmptyDuplicates(dups);
                            }
                            dups.add(info);
                            continue;
                        }
                    }
                    map.put(info.getName(), info);
                }
            }
        }
        if (!buf.isEmpty()) {
            buf.deleteCharAt(0);
            throw new MojoExecutionException(buf.toString());
        }
        return map;
    }

    private List<PackageInfo> getPackages(MavenProject project, String dirName) {
        ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
        this.checkDir(project, new File(dirName), packages, "");
        return packages;
    }

    private void checkDir(MavenProject project, File dir, List<PackageInfo> packages, String packageName) {
        if (dir.isDirectory()) {
            boolean containsFiles = false;
            boolean empty = true;
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isHidden()) continue;
                    empty = false;
                    if (file.isDirectory()) {
                        this.checkDir(project, file, packages, (String)(packageName.isEmpty() ? file.getName() : packageName + "." + file.getName()));
                        continue;
                    }
                    if (!file.isFile()) continue;
                    containsFiles = true;
                }
            }
            if ((empty || containsFiles) && !packageName.isEmpty()) {
                packages.add(new PackageInfo(packageName, project, dir));
            }
        }
    }
}

