/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.Objects;
import org.tentackle.common.Compare;
import org.tentackle.common.StringHelper;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactory;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeOptionsImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.parse.AttributeLine;
import org.tentackle.sql.Backend;

public class AttributeImpl
implements Attribute,
Comparable<AttributeImpl> {
    private final EntityFactoryImpl factory;
    private final Entity entity;
    private final SourceInfo sourceInfo;
    private final AttributeOptionsImpl options;
    private final boolean implicit;
    private AttributeLine sourceLine;
    private int ordinal;
    private String javaName;
    private String columnName;
    private DataType dataType;
    private String applicationType;
    private String innerName;
    private Integer size;
    private Integer scale;
    private Boolean nullable;
    private Relation relation;

    public AttributeImpl(EntityFactoryImpl factory, Entity entity, SourceInfo sourceInfo, boolean implicit) {
        this.factory = factory;
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.implicit = implicit;
        this.options = factory.createAttributeOptions(this, sourceInfo);
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public ModelElement getParent() {
        return this.getEntity();
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + Objects.hashCode(this.entity);
        hash = 73 * hash + Objects.hashCode(this.javaName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (!Objects.equals(this.entity, other.entity)) {
            return false;
        }
        return Objects.equals(this.javaName, other.javaName);
    }

    @Override
    public int compareTo(AttributeImpl o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        int rv = Compare.compare((Comparable)((EntityImpl)this.entity), (Comparable)((EntityImpl)o.entity));
        if (rv == 0) {
            rv = Compare.compare((Comparable)((Object)this.javaName), (Comparable)((Object)o.javaName));
        }
        return rv;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public boolean isHidden() {
        return this.options.isHidden() || this.options.isFromSuper() || this.options.getAccessScope() != AccessScope.PUBLIC;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void parse(Entity entity, AttributeLine line) throws ModelException {
        this.setSourceLine(line);
        this.setColumnName(line.getColumnName());
        this.setName(line.getJavaName());
        this.setScale(line.getScale());
        this.setSize(line.getSize());
        DataType type = DataType.createFromJavaType(line.getJavaType());
        if (Integer.valueOf(0).equals(line.getSize())) {
            type = DataType.LARGESTRING;
        }
        this.setDataType(type);
        if (this.getDataType() == null) {
            this.setDataType(DataType.APPLICATION);
        }
        this.setInnerName(line.getInnerName());
        if (this.getDataType() == DataType.APPLICATION) {
            this.setApplicationType(line.getJavaType());
            this.getInnerType();
        }
        this.getOptions().applyEntityOptions(entity.getOptions(), this.getDataType());
        this.getOptions().setComment(line.getComment());
        for (String option : line.getOptions()) {
            if (this.getOptions().processOption(option)) continue;
            if (option.startsWith("@")) {
                this.getOptions().getAnnotations().add(option);
                continue;
            }
            throw line.createModelException("illegal attribute option: " + option);
        }
        if (this.getOptions().getBindOptions().contains("SIZE")) {
            this.getOptions().removeBindOption("SIZE");
            if (this.getSize() != null && !this.getOptions().getBindOptions().contains("MAXCOLS")) {
                this.getOptions().addBindOption("MAXCOLS=" + this.getSize());
            }
            if (this.getScale() != null && !this.getOptions().getBindOptions().contains("SCALE")) {
                this.getOptions().addBindOption("SCALE=" + this.getScale());
            }
        }
    }

    public void setApplicationType(String applicationType) throws ModelException {
        if (applicationType != null && this.dataType != DataType.APPLICATION) {
            throw this.createModelException("setting the application specific type is not allowed for " + this);
        }
        this.applicationType = applicationType;
    }

    @Override
    public String getApplicationType() throws ModelException {
        if (this.dataType == DataType.APPLICATION) {
            if (this.applicationType == null || this.applicationType.trim().length() == 0) {
                throw this.createModelException("application specific type not set");
            }
        } else {
            throw this.createModelException("application specific type not supported for " + this);
        }
        return this.applicationType;
    }

    public void setInnerName(String innerType) throws ModelException {
        if (innerType != null && this.dataType != DataType.APPLICATION && this.dataType != DataType.BINARY) {
            throw this.createModelException("setting the inner type is not allowed for " + this);
        }
        this.innerName = innerType;
    }

    @Override
    public String getInnerName() throws ModelException {
        if (this.dataType == DataType.APPLICATION && this.innerName == null) {
            throw this.createModelException("inner type not set for application-specific type '" + this.getApplicationType() + "'");
        }
        if (this.dataType != DataType.APPLICATION && this.dataType != DataType.BINARY) {
            throw this.createModelException("inner type not supported for " + this);
        }
        return this.innerName;
    }

    @Override
    public DataType getInnerType() throws ModelException {
        DataType innerType = DataType.createFromJavaType(this.getInnerName());
        if (innerType == null) {
            throw this.createModelException("illegal inner type: " + this.getInnerName());
        }
        return innerType;
    }

    @Override
    public DataType getEffectiveType() throws ModelException {
        if (this.dataType == DataType.APPLICATION) {
            return this.getInnerType();
        }
        return this.dataType;
    }

    @Override
    public String getJavaType() throws ModelException {
        StringBuilder buf = new StringBuilder();
        if (this.dataType == DataType.APPLICATION) {
            buf.append(this.getApplicationType());
        } else {
            String genType;
            buf.append(this.dataType.toString());
            if (this.dataType == DataType.BINARY && (genType = this.getInnerName()) != null) {
                buf.append('<');
                buf.append(genType);
                buf.append('>');
            }
        }
        return buf.toString();
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public String getName() {
        return this.javaName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public int getSizeWithDefault() {
        return this.size == null ? 0 : this.size;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public int getScaleWithDefault() {
        return this.scale == null ? 0 : this.scale;
    }

    @Override
    public AttributeOptionsImpl getOptions() {
        return this.options;
    }

    public void setColumnName(String columnName) {
        this.columnName = StringHelper.toLower((String)columnName);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setName(String javaName) {
        this.javaName = javaName;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public boolean isNullable() throws ModelException {
        if (this.nullable != null) {
            return this.nullable;
        }
        DataType type = this.getEffectiveType();
        return !type.isPrimitive() && !this.getOptions().isMapNull();
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void validate() throws ModelException {
        if (StringHelper.isAllWhitespace((String)this.getName())) {
            throw this.createModelException("missing Java name");
        }
        if (StringHelper.isReservedWord((String)this.getName())) {
            throw this.createModelException("'" + this.getName() + "' is a reserved Java keyword");
        }
        if (StringHelper.isAllWhitespace((String)this.getColumnName())) {
            throw this.createModelException("missing column name");
        }
        for (Backend backend : this.factory.getBackends()) {
            try {
                backend.assertValidName("column name", this.getColumnName());
            }
            catch (RuntimeException rex) {
                throw new ModelException(rex.getMessage(), this, rex);
            }
        }
        if (this.dataType == null) {
            throw this.createModelException("missing data type");
        }
        if (this.dataType == DataType.APPLICATION) {
            this.getInnerType();
        }
        if (this.getScale() != null && !this.dataType.isNumeric()) {
            throw this.createModelException("non-numeric type does not support scale");
        }
        this.getOptions().validate();
        if (this.getOptions().isUTC() && this.dataType != DataType.TIMESTAMP) {
            throw this.createModelException("UTC option not applicable to " + this.dataType);
        }
        if (this.getOptions().isWithTimezone() && !this.dataType.isDateOrTime()) {
            throw this.createModelException("TZ option not applicable to " + this.dataType);
        }
        if (this.getOptions().isMapNull()) {
            switch (this.dataType) {
                case CHARACTER: 
                case STRING: 
                case LARGESTRING: 
                case DATE: 
                case TIMESTAMP: 
                case LOCALDATE: 
                case LOCALDATETIME: {
                    break;
                }
                default: {
                    throw this.createModelException("MAPNULL option not applicable to " + this.dataType);
                }
            }
        }
    }

    public AttributeLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(AttributeLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this);
        return ex;
    }

    @Override
    public String getMethodNameSuffix() {
        return StringHelper.firstToUpper((String)this.javaName);
    }

    @Override
    public String getGetterName() {
        return CodeFactory.getInstance().createGetterName(this);
    }

    @Override
    public String getSetterName() {
        return CodeFactory.getInstance().createSetterName(this);
    }

    @Override
    public String getBindableAnnotation() {
        return CodeFactory.getInstance().createBindableAnnotation(this);
    }

    @Override
    public String toMethodArgument(String value) {
        return CodeFactory.getInstance().createMethodArgument(this, value);
    }
}

