/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.File;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelException;
import org.tentackle.model.impl.ModelEntity;

public class ModelEntityImpl
implements ModelEntity {
    private final Entity entity;
    private final String fileName;
    private final File file;
    private final long lastModified;

    public ModelEntityImpl(Entity entity, String fileName) throws ModelException {
        this.entity = entity;
        this.fileName = fileName;
        this.file = new File(fileName);
        if (!this.file.exists()) {
            throw new ModelException(fileName + " does not exist");
        }
        if (!this.file.isFile()) {
            throw new ModelException(fileName + " is not a regular file");
        }
        this.lastModified = this.file.lastModified();
    }

    public String toString() {
        return this.entity.toString();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean hasChanged() {
        return this.file.lastModified() > this.lastModified;
    }
}

