/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.Service;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.EntityFactory;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Integrity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelError;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.TrackType;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.impl.EntityOptionsImpl;
import org.tentackle.model.impl.ForeignKeyImpl;
import org.tentackle.model.impl.IndexImpl;
import org.tentackle.model.impl.ModelDirectory;
import org.tentackle.model.impl.ModelDirectoryImpl;
import org.tentackle.model.impl.ModelEntity;
import org.tentackle.model.impl.ModelEntityImpl;
import org.tentackle.model.impl.RelationImpl;
import org.tentackle.sql.Backend;

@Service(value=Model.class)
public class ModelImpl
implements Model {
    private final Map<String, ModelEntity> mapByFileName;
    private final Map<String, ModelEntity> mapByEntityName;
    private final Map<Integer, ModelEntity> mapByClassId;
    private final Map<String, ModelDirectory> modelDirs;
    private final EntityFactory entityFactory = this.createEntityFactory();
    private Collection<ForeignKey> foreignKeys;
    private boolean mapSchemas;

    public ModelImpl() {
        this.mapByEntityName = new TreeMap<String, ModelEntity>();
        this.mapByClassId = new HashMap<Integer, ModelEntity>();
        this.mapByFileName = new HashMap<String, ModelEntity>();
        this.modelDirs = new HashMap<String, ModelDirectory>();
    }

    @Override
    public void setSchemaNameMapped(boolean mapSchemas) {
        this.mapSchemas = mapSchemas;
    }

    @Override
    public boolean isSchemaNameMapped() {
        return this.mapSchemas;
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    @Override
    public synchronized void loadModel(String modelDir, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        ModelDirectory dir = this.modelDirs.get(modelDir);
        if (dir == null || dir.hasChanged()) {
            dir = this.createModelDirectory(modelDir, defaults, aliases);
            this.modelDirs.put(modelDir, dir);
            for (String string : dir.getFileNames()) {
                File file = new File(string);
                if (file.isHidden()) continue;
                this.loadByFileName(file.getPath(), defaults, aliases, false);
            }
            this.updateRelations(defaults, aliases);
        }
        if (defaults != null) {
            Entity entity;
            boolean updateRelations = false;
            if (defaults.getTrackType() != null) {
                for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                    entity = modelEntity.getEntity();
                    if (entity.getOptions().noModelDefaults() || defaults.getTrackType().ordinal() <= entity.getOptions().getTrackType().ordinal()) continue;
                    ((EntityImpl)entity).getOptions().setTrackType(defaults.getTrackType());
                    updateRelations = true;
                }
            }
            if (defaults.getDeletionCascaded() != null && defaults.getDeletionCascaded().booleanValue()) {
                for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                    entity = modelEntity.getEntity();
                    if (entity.getOptions().noModelDefaults()) continue;
                    for (Relation relation : entity.getRelations()) {
                        if (!relation.isComposite() || relation.isDeletionCascaded()) continue;
                        ((RelationImpl)relation).setDeletionCascaded(defaults.getDeletionCascaded());
                        updateRelations = true;
                    }
                }
            }
            if (updateRelations) {
                this.updateRelations(defaults, aliases);
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            EntityImpl entity = (EntityImpl)modelEntity.getEntity();
            for (Index idx : entity.getIndexes()) {
                IndexImpl index = (IndexImpl)idx;
                if (index.isParsed()) continue;
                index.parse(entity);
            }
            entity.validate();
        }
    }

    @Override
    public synchronized void clearModel() {
        this.mapByEntityName.clear();
        this.mapByClassId.clear();
        this.mapByFileName.clear();
        this.modelDirs.clear();
    }

    @Override
    public void refreshModel() throws ModelException {
        for (ModelDirectory modelDir : this.modelDirs.values()) {
            modelDir.markDirty();
            this.loadModel(modelDir.getPath(), modelDir.getModelDefaults(), modelDir.getEntityAliases());
        }
    }

    @Override
    public synchronized Collection<Entity> getAllEntitites() throws ModelException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        boolean refreshed = false;
        block0: do {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                if (modelEntity.hasChanged()) {
                    this.refreshModel();
                    list.clear();
                    refreshed = true;
                    continue block0;
                }
                list.add(modelEntity.getEntity());
            }
        } while (refreshed);
        return list;
    }

    @Override
    public synchronized Entity getByFileName(String fileName) throws ModelException {
        ModelEntity modelEntity = this.mapByFileName.get(fileName);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByFileName.get(fileName);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByEntityName(String entityName) throws ModelException {
        String name = entityName.toLowerCase();
        ModelEntity modelEntity = this.mapByEntityName.get(name);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByEntityName.get(name);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByClassId(int classId) throws ModelException {
        ModelEntity modelEntity = this.mapByClassId.get(classId);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByClassId.get(classId);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public Entity loadByFileName(String fileName, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        return this.loadByFileName(fileName, defaults, aliases, true);
    }

    protected synchronized Entity loadByFileName(String fileName, ModelDefaults defaults, EntityAliases aliases, boolean updateRelations) throws ModelException {
        ModelEntity modelEntity = this.mapByFileName.get(fileName);
        if (modelEntity != null && modelEntity.hasChanged()) {
            modelEntity = null;
        }
        if (modelEntity == null) {
            try {
                Entity entity = this.parseEntity(defaults, fileName);
                modelEntity = this.createModelEntity(entity, fileName);
            }
            catch (ModelException mex) {
                String msg = "parsing '" + fileName + "' failed:\n    " + ExceptionHelper.concatenateMessages((Throwable)mex);
                throw new ModelException(msg, mex.getElement(), mex);
            }
            this.addModelEntity(modelEntity);
            this.foreignKeys = null;
            if (updateRelations) {
                this.updateRelations(defaults, aliases, modelEntity);
            }
        }
        return modelEntity.getEntity();
    }

    protected Entity parseEntity(ModelDefaults defaults, String fileName) throws ModelException {
        StringBuilder modelSource = new StringBuilder();
        try (Reader reader = this.createReader(fileName);){
            int len;
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                modelSource.append(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new ModelException("reading model '" + fileName + "' failed", ex);
        }
        return this.getEntityFactory().createEntity(modelSource.toString(), defaults);
    }

    protected void addModelEntity(ModelEntity modelEntity) throws ModelException {
        String tableName;
        if (this.mapSchemas && (tableName = modelEntity.getEntity().getTableName()) != null) {
            ((EntityImpl)modelEntity.getEntity()).setTableName(tableName.replace('.', '_'));
        }
        String fileName = modelEntity.getFileName();
        this.mapByFileName.put(fileName, modelEntity);
        ModelEntity oldModelEntity = this.mapByEntityName.put(modelEntity.getEntity().getName().toLowerCase(), modelEntity);
        if (modelEntity.getEntity().getClassId() != 0) {
            if (oldModelEntity != null && oldModelEntity.getEntity().getClassId() != modelEntity.getEntity().getClassId()) {
                throw new ModelException("duplicate entity " + modelEntity.getEntity().getName() + " in file " + fileName, modelEntity.getEntity());
            }
            oldModelEntity = this.mapByClassId.put(modelEntity.getEntity().getClassId(), modelEntity);
            if (oldModelEntity != null && !oldModelEntity.getEntity().getName().equals(modelEntity.getEntity().getName())) {
                throw new ModelException("duplicate entity id " + modelEntity.getEntity().getClassId() + " for " + modelEntity.getEntity().getName() + ", already assigned to " + oldModelEntity.getEntity().getName(), modelEntity.getEntity());
            }
        }
    }

    protected void updateRelations(ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        this.updateRelations(defaults, aliases, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateRelations(ModelDefaults defaults, EntityAliases aliases, ModelEntity loadedModelEntity) throws ModelException {
        Entity entity;
        LinkedHashSet<ModelError> errors = new LinkedHashSet<ModelError>();
        Entity loadedEntity = loadedModelEntity == null ? null : loadedModelEntity.getEntity();
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            modelEntity.getEntity().getSubEntities().clear();
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getSuperEntityName() == null) continue;
            Entity superEntity = this.getByEntityName(this.translateAlias(aliases, entity.getSuperEntityName()));
            if (superEntity == null) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                errors.add(new ModelError(entity, "no such super entity '" + entity.getSuperEntityName() + "' to be extended by '" + entity + "'"));
                continue;
            }
            ((EntityImpl)entity).setSuperEntity(superEntity);
            if (superEntity.getInheritanceType() == InheritanceType.NONE && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                errors.add(new ModelError(entity, "super entity '" + superEntity + "' extended by '" + entity + "' is not extensible (missing inheritance := ... ?)"));
            }
            superEntity.getSubEntities().add(entity);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            entity.getReferencingRelations().clear();
            entity.getCompositePaths().clear();
            entity.getDeepReferences().clear();
            entity.getDeepReferencesToComponents().clear();
            ((EntityImpl)entity).setDeeplyReferenced(false);
            for (Relation relation : entity.getRelations()) {
                void var13_100;
                ((RelationImpl)relation).setForeignRelation(null);
                Entity entity2 = this.getByEntityName(this.translateAlias(aliases, relation.getClassName()));
                if (entity2 == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    errors.add(new ModelError(relation, "no such entity: " + relation.getClassName()));
                    continue;
                }
                ((RelationImpl)relation).setForeignEntity(entity2);
                if (relation.getRelationType() != RelationType.LIST) continue;
                Object attributeName = relation.getMethodName() != null ? relation.getMethodName() : relation.getEntity().getName() + "Id";
                Attribute attribute = entity2.getAttributeByJavaName((String)(attributeName = StringHelper.firstToLower((String)attributeName)), true);
                if (attribute == null) {
                    for (Relation fRel : entity2.getRelations()) {
                        if (fRel.getRelationType() != RelationType.OBJECT || !relation.getEntity().getName().equals(fRel.getClassName())) continue;
                        attributeName = StringHelper.firstToLower((String)(fRel.getName() + "Id"));
                        Attribute attribute2 = entity2.getAttributeByJavaName((String)attributeName, true);
                        break;
                    }
                    if (var13_100 == null && relation.getMethodArgs().isEmpty() && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                        errors.add(new ModelError(relation, "no such attribute: " + (String)attributeName + " in " + entity2 + " referenced by " + entity));
                    }
                }
                ((RelationImpl)relation).setForeignAttribute((Attribute)var13_100);
                if (relation.getNmName() == null) continue;
                Relation nmRelation = entity2.getRelation(relation.getNmName(), false);
                if (nmRelation == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    errors.add(new ModelError(relation, "no such nm-relation: " + relation.getNmName() + " in " + entity2));
                    continue;
                }
                if ((nmRelation.isComposite() || nmRelation.getRelationType() == RelationType.LIST) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    errors.add(new ModelError(nmRelation, "nm-relation " + nmRelation.getName() + " in " + entity2 + " must be non-composite object"));
                }
                if (this.translateAlias(aliases, nmRelation.getClassName()).equals(entity.getName()) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    errors.add(new ModelError(nmRelation, "nm-relation " + nmRelation.getName() + " in " + entity2 + " points back to " + entity));
                }
                if (nmRelation.getSelectionType() == SelectionType.LAZY && !nmRelation.isSerialized()) {
                    ((RelationImpl)nmRelation).setSerialized(true);
                    ((RelationImpl)nmRelation).setClearOnRemoteSave(true);
                }
                ((RelationImpl)relation).setNmRelation(nmRelation);
                ((RelationImpl)nmRelation).setDefiningNmRelation(relation);
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            for (ModelEntity modelEntity2 : this.mapByEntityName.values()) {
                Entity entity3 = modelEntity2.getEntity();
                for (Relation relation : entity3.getRelations()) {
                    Entity foreignEntity = relation.getForeignEntity();
                    if (foreignEntity == null || !foreignEntity.equals(entity)) continue;
                    entity.getReferencingRelations().add(relation);
                }
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            block13: for (Relation relation : entity.getReferencingRelations()) {
                if (relation.getForeignRelation() != null) continue;
                for (Relation otherRelation : relation.getForeignEntity().getTableRelations()) {
                    if (!Objects.equals(relation.getEntity(), otherRelation.getForeignEntity()) || !Objects.equals(relation.getAttribute(), otherRelation.getForeignAttribute())) continue;
                    ((RelationImpl)relation).setForeignRelation(otherRelation);
                    ((RelationImpl)otherRelation).setForeignRelation(relation);
                    continue block13;
                }
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            boolean isRootEntity = true;
            for (Relation relation : entity.getAllReferencingRelations()) {
                if (!relation.isComposite()) continue;
                isRootEntity = false;
                break;
            }
            ((EntityImpl)entity).setRootEntityAccordingToModel(isRootEntity);
            if (!isRootEntity) continue;
            for (Relation relation : entity.getAllRelations()) {
                if (!relation.isComposite() || relation.getForeignEntity() == null) continue;
                Iterator<Entity> compositePath = new ArrayList<Relation>();
                compositePath.add((Entity)((Object)relation));
                this.updateCompositePath((List<Relation>)((Object)compositePath), relation.getForeignEntity());
            }
        }
        block18: for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            Set<Entity> rootEntities = entity.getRootEntities();
            if (rootEntities.size() > 1 && entity.getRootAttribute() != null) {
                ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
            }
            if (!rootEntities.isEmpty()) {
                for (Relation relation : entity.getReferencingRelationsIncludingSubEntities()) {
                    if (relation.isComposite() || relation.getForeignRelation() != null && relation.getForeignRelation().isComposite() || rootEntities.containsAll(relation.getEntity().getRootEntities())) continue;
                    ((RelationImpl)relation).setDeepReference(true);
                    ((EntityImpl)entity).setDeeplyReferenced(true);
                    entity.getDeepReferences().add(relation);
                    for (List list : entity.getCompositePaths()) {
                        for (Relation compositeRelation : list) {
                            ((EntityImpl)compositeRelation.getEntity()).setDeeplyReferenced(true);
                        }
                    }
                    for (Entity entity4 : rootEntities) {
                        entity4.getDeepReferencesToComponents().add(relation);
                    }
                    if (entity.getRootEntity() != null) continue;
                    ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
                }
            }
            for (List<Relation> list : entity.getCompositePaths()) {
                if (list.size() <= 1 && list.get(list.size() - 1).getRelationType() != RelationType.OBJECT) continue;
                ((EntityImpl)entity).setProvidingRootIdAccordingToModel(true);
                continue block18;
            }
        }
        if (defaults != null) {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                entity = modelEntity.getEntity();
                if (entity.getOptions().noModelDefaults()) continue;
                if (defaults.getTrackType() != null && defaults.getTrackType().ordinal() > entity.getOptions().getTrackType().ordinal()) {
                    ((EntityOptionsImpl)entity.getOptions()).setTrackType(defaults.getTrackType());
                }
                if (Boolean.TRUE.equals(defaults.getRoot()) && entity.isRootEntityAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootEntity(true);
                }
                if (Boolean.TRUE.equals(defaults.getRootClassId()) && entity.isProvidingRootClassIdAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootClassIdProvided(true);
                }
                if (Boolean.TRUE.equals(defaults.getRootId()) && entity.isProvidingRootIdAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootIdProvided(true);
                }
                if (defaults.getRemote() == null) continue;
                ((EntityOptionsImpl)entity.getOptions()).setRemote(defaults.getRemote());
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getOptions().isRootClassIdProvided()) {
                if (entity.getAttributeByColumnName("rootclassid", true) == null) {
                    ((EntityImpl)entity).getOptions().applyOption("ROOTCLASSID", Boolean.TRUE);
                }
            } else {
                Attribute rootClassAttribute = entity.getAttributeByColumnName("rootclassid", false);
                if (rootClassAttribute != null) {
                    entity.getAttributes().remove(rootClassAttribute);
                }
            }
            if (entity.getOptions().isRootIdProvided()) {
                if (entity.getAttributeByColumnName("rootid", true) != null) continue;
                ((EntityImpl)entity).getOptions().applyOption("ROOTID", Boolean.TRUE);
                continue;
            }
            Attribute rootAttribute = entity.getAttributeByColumnName("rootid", false);
            if (rootAttribute == null) continue;
            entity.getAttributes().remove(rootAttribute);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            for (Relation relation : entity.getRelations()) {
                if (relation.getEntity().getOptions().getTrackType().isTracked()) {
                    ((RelationImpl)relation).setTracked(true);
                }
                if (!relation.isComposite() || relation.getForeignEntity() == null) continue;
                if (relation.getRelationType() == RelationType.LIST) {
                    void var11_87;
                    Iterator parentRelations;
                    Relation relation2 = relation.getForeignEntity().getRelation(entity.getName(), true);
                    if (relation2 == null && (parentRelations = relation.getForeignEntity().getRelations(entity, true)).size() == 1) {
                        Relation relation3 = (Relation)parentRelations.get(0);
                    }
                    if (var11_87 != null && var11_87.getRelationType() == RelationType.OBJECT && var11_87.getSelectionType() == SelectionType.LAZY) {
                        ((RelationImpl)relation).setLinkMethodName("set" + StringHelper.firstToUpper((String)var11_87.getName()));
                    }
                }
                if (relation.getLinkMethodName() != null) {
                    ((RelationImpl)relation).setReferenced(true);
                }
                if (relation.isTracked() || !entity.getIntegrity().isCompositesCheckedByDatabase()) continue;
                errors.add(new ModelError(relation, "untracked relation " + relation + " not allowed in conjunction with " + entity.getIntegrity() + "-integrity in " + entity));
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            try {
                ((EntityImpl)entity).validateRelated();
            }
            catch (ModelException mex) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                errors.add(new ModelError(entity, mex.getMessage() + " in " + entity));
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getSuperEntity() != null || entity.getInheritanceType().isMappingToNoTable()) continue;
            HashMap<String, AttributeImpl> columnMap = new HashMap<String, AttributeImpl>();
            HashMap<String, AttributeImpl> hashMap = new HashMap<String, AttributeImpl>();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(entity.getAttributes());
            for (Entity entity5 : entity.getAllSubEntities()) {
                arrayList.addAll(entity5.getAttributes());
            }
            for (Attribute attribute : arrayList) {
                AttributeImpl attribute3 = (AttributeImpl)attribute;
                AttributeImpl oldAttribute = hashMap.put(attribute3.getName().toLowerCase(), attribute3);
                if (oldAttribute != null && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    StringBuilder exMsg = new StringBuilder();
                    exMsg.append("attribute '").append(attribute3.getName()).append("' in ").append(attribute3.getEntity());
                    exMsg.append(" already defined in ").append(oldAttribute.getEntity());
                    if (oldAttribute.getSourceLine() != null) {
                        exMsg.append("(").append(oldAttribute.getSourceLine()).append(")");
                    }
                    errors.add(new ModelError(attribute3, exMsg.toString()));
                }
                AttributeImpl oldColumn = columnMap.put(attribute3.getColumnName().toLowerCase(), attribute3);
                if (oldAttribute != null || oldColumn == null || loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                StringBuilder exMsg = new StringBuilder();
                exMsg.append("column '").append(attribute3.getColumnName()).append("' in ").append(attribute3.getEntity());
                exMsg.append(" already defined in ").append(oldColumn.getEntity());
                if (oldColumn.getSourceLine() != null) {
                    exMsg.append("(").append(oldColumn.getSourceLine()).append(")");
                }
                exMsg.append(" as attribute '").append(attribute3).append("'");
                errors.add(new ModelError(attribute3, exMsg.toString()));
            }
        }
        HashMap<Object, Entity> aliasMap = new HashMap<Object, Entity>();
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            Entity entity2 = modelEntity.getEntity();
            if (entity2.getTableAlias() == null) continue;
            Entity entity6 = (Entity)aliasMap.get(entity2.getTableAlias());
            if (entity6 != null) {
                errors.add(new ModelError(entity6, "table alias '" + entity2.getTableAlias() + "' defined more than once in " + entity2 + " and " + entity6));
                continue;
            }
            aliasMap.put(entity2.getTableAlias(), entity2);
        }
        block33: for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            String alias;
            int n;
            int n2;
            Entity entity3 = modelEntity.getEntity();
            if (entity3.getTableName() == null || entity3.getTableAlias() != null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 95;
            for (int i = 0; i < entity3.getName().length(); ++i) {
                n2 = entity3.getName().charAt(i);
                if (Character.isUpperCase((char)n2)) {
                    stringBuilder.append((char)n2);
                }
                n = n2;
            }
            if (stringBuilder.length() <= 1) {
                stringBuilder.append((char)n);
            }
            if (aliasMap.get(alias = stringBuilder.toString().toLowerCase()) == null) {
                n2 = 1;
                for (Backend backend : this.getEntityFactory().getBackends()) {
                    try {
                        backend.assertValidName("table alias", alias);
                    }
                    catch (RuntimeException rex) {
                        n2 = 0;
                        break;
                    }
                }
                if (n2 != 0) {
                    ((EntityImpl)entity3).setTableAlias(alias);
                    aliasMap.put(alias, entity3);
                    continue;
                }
            }
            n2 = 1;
            while (true) {
                String numberedAlias;
                if (aliasMap.get(numberedAlias = alias.substring(0, 1) + n2) == null) {
                    ((EntityImpl)entity3).setTableAlias(numberedAlias);
                    aliasMap.put(numberedAlias, entity3);
                    continue block33;
                }
                ++n2;
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            void var10_71;
            void var11_93;
            Entity entity4 = modelEntity.getEntity();
            boolean bl = false;
            Entity entity7 = entity4.getSuperEntity();
            while (var11_93 != null) {
                ++var10_71;
                Entity entity8 = var11_93.getSuperEntity();
            }
            ((EntityImpl)entity4).setOrdinal((int)var10_71);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            int n;
            Entity entity5 = modelEntity.getEntity();
            if (entity5.isAbstract()) continue;
            Entity[] entityArray = new Entity[modelEntity.getEntity().getOrdinal() + 1];
            List<Entity> list = entity5.getSuperEntities();
            int superNdx = list.size() - 1;
            for (n = 0; n < entityArray.length; ++n) {
                entityArray[n] = n < list.size() ? list.get(superNdx--) : entity5;
            }
            n = 0;
            int relationOrdinal = 0;
            int indexOrdinal = 0;
            for (Entity nextEntity : entityArray) {
                for (Attribute attribute : nextEntity.getAttributes()) {
                    ((AttributeImpl)attribute).setOrdinal(n++);
                }
                for (Relation relation : nextEntity.getRelations()) {
                    ((RelationImpl)relation).setOrdinal(relationOrdinal++);
                }
                for (Index index : nextEntity.getIndexes()) {
                    ((IndexImpl)index).setOrdinal(indexOrdinal++);
                }
            }
        }
        if (loadedEntity != null) {
            Entity entity9 = loadedEntity.getTopSuperEntity();
            this.validateInheritanceHierarchy(entity9, entity9.getInheritanceType(), entity9.getOptions().getTrackType(), entity9.getIntegrity(), errors);
            this.validateComponents(entity9, entity9.getIntegrity(), errors);
        } else {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                Entity entity6 = modelEntity.getEntity();
                this.validateInheritanceHierarchy(entity6, entity6.getInheritanceType(), entity6.getOptions().getTrackType(), entity6.getIntegrity(), errors);
                this.validateComponents(entity6, entity6.getIntegrity(), errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new ModelException(errors);
        }
    }

    protected void updateCompositePath(List<Relation> compositePath, Entity entity) {
        Relation lastRelation = compositePath.get(compositePath.size() - 1);
        if (lastRelation.getForeignAttribute() != null) {
            entity = lastRelation.getForeignAttribute().getEntity();
        }
        entity.getCompositePaths().add(compositePath);
        for (Relation relation : entity.getAllRelations()) {
            Entity foreignEntity;
            if (!relation.isComposite() || (foreignEntity = relation.getForeignEntity()) == null || foreignEntity.equals(entity)) continue;
            ArrayList<Relation> newPath = new ArrayList<Relation>(compositePath);
            newPath.add(relation);
            this.updateCompositePath(newPath, foreignEntity);
        }
    }

    @Override
    public synchronized Collection<ForeignKey> getForeignKeys() throws ModelException {
        if (this.foreignKeys == null) {
            TreeMap<ForeignKeyImpl, ForeignKeyImpl> foreignKeyMap = new TreeMap<ForeignKeyImpl, ForeignKeyImpl>();
            LinkedHashSet<ModelError> errors = new LinkedHashSet<ModelError>();
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                Entity entity = modelEntity.getEntity();
                if (!entity.getInheritanceType().isMappingToOwnTable()) continue;
                for (Relation relation : entity.getTableRelations()) {
                    List<Object> referencingEntities;
                    Relation foreignRelation;
                    Attribute referencingAttribute = null;
                    Entity referencingEntity = null;
                    Attribute referencedAttribute = null;
                    Entity referencedEntity = null;
                    boolean composite = relation.isComposite();
                    if (!composite && (foreignRelation = relation.getForeignRelation()) != null && foreignRelation.getRelationType() == RelationType.LIST && foreignRelation.isComposite()) {
                        composite = true;
                    }
                    if (relation.getAttribute() != null) {
                        if (relation.getForeignEntity() == null) {
                            errors.add(new ModelError(relation, "no foreign entity for " + relation));
                        } else {
                            referencingEntity = relation.getEntity();
                            referencingAttribute = relation.getAttribute();
                            referencedEntity = relation.getForeignEntity();
                            referencedAttribute = referencedEntity.getAttributeByJavaName("id", true);
                        }
                    } else if (relation.getForeignAttribute() != null) {
                        referencingEntity = relation.getForeignEntity();
                        referencingAttribute = relation.getForeignAttribute();
                        referencedEntity = entity;
                        referencedAttribute = entity.getAttributeByJavaName("id", true);
                    } else {
                        if (!relation.getMethodArgs().isEmpty()) continue;
                        errors.add(new ModelError(relation, "broken foreign key relation " + relation + " in " + entity));
                    }
                    if (referencingEntity != null && referencingEntity.getTableProvidingEntity() == null) {
                        referencingEntities = referencingEntity.getLeafEntities();
                    } else {
                        referencingEntities = new ArrayList();
                        if (referencedEntity != null) {
                            referencingEntities.add(referencingEntity);
                        }
                    }
                    for (Entity entity2 : referencingEntities) {
                        if (referencingAttribute == null || referencedAttribute == null || (composite || !referencedAttribute.getEntity().getIntegrity().isRelatedCheckedByDatabase()) && (!composite || !referencedAttribute.getEntity().getIntegrity().isCompositesCheckedByDatabase())) continue;
                        ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity2, referencingAttribute, referencedEntity, referencedAttribute, composite);
                        ForeignKey oppositeForeignKey = (ForeignKey)foreignKeyMap.get(foreignKey);
                        if (oppositeForeignKey != null) {
                            if (!composite || oppositeForeignKey.isComposite()) continue;
                            ((ForeignKeyImpl)oppositeForeignKey).setComposite(true);
                            continue;
                        }
                        foreignKeyMap.put(foreignKey, foreignKey);
                    }
                }
                if (entity.getSuperEntity() == null || !entity.getHierarchyInheritanceType().isMappingToOwnTable()) continue;
                Entity topEntity = entity.getTopSuperEntity();
                Attribute idAttribute = topEntity.getAttributeByJavaName("id", false);
                ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity, idAttribute, topEntity, idAttribute, false);
                foreignKeyMap.put(foreignKey, foreignKey);
            }
            if (!errors.isEmpty()) {
                throw new ModelException(errors);
            }
            this.foreignKeys = foreignKeyMap.values();
        }
        return this.foreignKeys;
    }

    protected EntityFactory createEntityFactory() {
        return new EntityFactoryImpl();
    }

    protected ModelDirectory createModelDirectory(String modelDir, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        return new ModelDirectoryImpl(modelDir, defaults, aliases);
    }

    protected ModelEntity createModelEntity(Entity entity, String fileName) throws ModelException {
        return new ModelEntityImpl(entity, fileName);
    }

    protected Reader createReader(String name) throws ModelException {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), Settings.getEncodingCharset()));
        }
        catch (IOException ex) {
            throw new ModelException("cannot open reader for " + name, ex);
        }
    }

    protected void validateInheritanceHierarchy(Entity entity, InheritanceType inheritanceType, TrackType trackType, Integrity integrity, Set<ModelError> errors) {
        if (entity.getOptions().getTrackType() != trackType) {
            errors.add(new ModelError(entity, entity + " has wrong track type " + entity.getOptions().getTrackType() + ", expected " + trackType));
        }
        if (entity.getIntegrity() != integrity) {
            errors.add(new ModelError(entity, entity + " has wrong integrity type " + entity.getIntegrity() + ", expected " + integrity));
        }
        if (!entity.getSubEntities().isEmpty()) {
            if (entity.getInheritanceType() != inheritanceType) {
                errors.add(new ModelError(entity, entity + " has wrong inheritance type " + entity.getInheritanceType() + ", expected " + inheritanceType));
            }
            for (Entity child : entity.getSubEntities()) {
                this.validateInheritanceHierarchy(child, inheritanceType, trackType, integrity, errors);
            }
        }
    }

    protected void validateComponents(Entity entity, Integrity integrity, Set<ModelError> errors) {
        if (entity.getIntegrity() != integrity) {
            errors.add(new ModelError(entity, entity + " has wrong integrity type " + entity.getIntegrity() + ", expected " + integrity));
        }
        for (Relation relation : entity.getRelations()) {
            Entity foreignEntity;
            if (!relation.isComposite() || (foreignEntity = relation.getForeignEntity()) == null || foreignEntity.equals(entity)) continue;
            this.validateComponents(foreignEntity, integrity, errors);
        }
    }

    protected String translateAlias(EntityAliases aliases, String name) {
        String mappedName;
        if (aliases != null && (mappedName = (String)aliases.get(name)) != null) {
            name = mappedName;
        }
        return name;
    }
}

