/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.sql.Backend;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.IndexMetaData;

public class IndexMigrator {
    private final Backend backend;
    private final Entity entity;
    private final Index index;
    private final IndexMetaData indexMetaData;

    public IndexMigrator(Entity entity, Index index, Backend backend, IndexMetaData indexMetaData) {
        this.backend = backend;
        this.entity = entity;
        this.index = index;
        this.indexMetaData = indexMetaData;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public Index getIndex() {
        return this.index;
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public Result migrate() {
        StringBuilder dropSql = new StringBuilder();
        StringBuilder createSql = new StringBuilder();
        if (this.indexMetaData == null) {
            createSql.append(this.createIndex());
        } else if (this.index == null) {
            dropSql.append(this.dropIndex());
        } else {
            boolean changed;
            boolean bl = changed = this.index.isUnique() != this.indexMetaData.isUnique();
            if (!changed) {
                String modelFilter = this.index.getFilterCondition();
                modelFilter = StringHelper.isAllWhitespace((String)modelFilter) ? "" : modelFilter.toUpperCase().replace(" ", "");
                String currentFilter = this.indexMetaData.getFilterCondition();
                currentFilter = StringHelper.isAllWhitespace((String)currentFilter) ? "" : currentFilter.toUpperCase().replace(" ", "");
                boolean bl2 = changed = !this.equalsIgnoreMatchingParenthesis(modelFilter, currentFilter);
            }
            if (!changed) {
                if (this.index.getAttributes().size() == this.indexMetaData.getColumns().size()) {
                    for (int position = 0; position < this.index.getAttributes().size(); ++position) {
                        IndexAttribute indexAttribute = this.index.getAttributes().get(position);
                        IndexColumnMetaData indexColumn = (IndexColumnMetaData)this.indexMetaData.getColumns().get(position);
                        if (indexAttribute.isDescending() == indexColumn.isDescending() && indexAttribute.getAttribute().getColumnName().equals(indexColumn.getColumnName())) continue;
                        changed = true;
                        break;
                    }
                } else {
                    changed = true;
                }
            }
            if (changed) {
                dropSql.append(this.dropIndex());
                createSql.append(this.createIndex());
            }
        }
        return new Result(dropSql.toString(), createSql.toString());
    }

    private String createIndex() {
        return this.index.sqlCreateIndex(this.backend, this.entity);
    }

    private String dropIndex() {
        return this.backend.sqlDropIndex(this.indexMetaData.getTableMetaData().getSchemaName(), this.indexMetaData.getTableMetaData().getTableName(), this.indexMetaData.getIndexName());
    }

    private boolean equalsIgnoreMatchingParenthesis(String s1, String s2) {
        int ndx1 = 0;
        int ndx2 = 0;
        int pending1 = 0;
        int pending2 = 0;
        while (ndx1 < s1.length() || ndx2 < s2.length()) {
            char c2;
            char c1 = ndx1 < s1.length() ? s1.charAt(ndx1) : (char)'\u0000';
            char c = c2 = ndx2 < s2.length() ? s2.charAt(ndx2) : (char)'\u0000';
            if (c1 != c2) {
                if (c1 == '(') {
                    ++pending1;
                    ++ndx1;
                    continue;
                }
                if (c1 == ')') {
                    if (pending1 <= 0) break;
                    --pending1;
                    ++ndx1;
                    continue;
                }
                if (c2 == '(') {
                    ++pending2;
                    ++ndx2;
                    continue;
                }
                if (c2 != ')' || pending2 <= 0) break;
                --pending2;
                ++ndx2;
                continue;
            }
            if (ndx1 < s1.length()) {
                ++ndx1;
            }
            if (ndx2 >= s2.length()) continue;
            ++ndx2;
        }
        return ndx1 == s1.length() && ndx2 == s2.length() && pending1 == 0 && pending2 == 0;
    }

    public static class Result {
        private final String dropSql;
        private final String createSql;

        public Result(String dropSql, String createSql) {
            this.dropSql = dropSql;
            this.createSql = createSql;
        }

        public String getDropSql() {
            return this.dropSql;
        }

        public String getCreateSql() {
            return this.createSql;
        }

        public Result sum(Result result) {
            return new Result(this.dropSql + result.dropSql, this.createSql + result.createSql);
        }
    }
}

