/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

import org.tentackle.model.parse.AttributeLine;
import org.tentackle.model.parse.CommentLine;
import org.tentackle.model.parse.ConfigurationLine;
import org.tentackle.model.parse.Document;
import org.tentackle.model.parse.EmptyLine;
import org.tentackle.model.parse.GlobalOptionLine;
import org.tentackle.model.parse.Line;
import org.tentackle.model.parse.OptionLine;
import org.tentackle.model.parse.RelationLine;

public enum LineType {
    EMPTY,
    COMMENT,
    CONFIGURATION,
    GLOBAL_OPTION,
    ATTRIBUTE,
    ATTRIBUTE_OPTION,
    RELATION,
    RELATION_OPTION;


    public Line createLine(Document document, int offset) {
        switch (this) {
            case EMPTY: {
                return new EmptyLine(document, offset, this);
            }
            case COMMENT: {
                return new CommentLine(document, offset, this);
            }
            case CONFIGURATION: {
                return new ConfigurationLine(document, offset, this);
            }
            case GLOBAL_OPTION: {
                return new GlobalOptionLine(document, offset, this);
            }
            case ATTRIBUTE_OPTION: 
            case RELATION_OPTION: {
                return new OptionLine(document, offset, this);
            }
            case ATTRIBUTE: {
                return new AttributeLine(document, offset, this);
            }
            case RELATION: {
                return new RelationLine(document, offset, this);
            }
        }
        throw new IllegalArgumentException("unimplemented line type");
    }
}

