/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import java.util.Objects;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityOptions;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.TrackType;
import org.tentackle.model.print.PrintConfiguration;

public class GlobalOptionsPrinter {
    private final Entity entity;
    private final PrintConfiguration configuration;

    public GlobalOptionsPrinter(Entity entity, PrintConfiguration configuration) {
        this.entity = entity;
        this.configuration = configuration;
    }

    public String print() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        EntityOptions options = this.entity.getOptions();
        if (options.isLowerCase()) {
            buf.append("LC").append(',');
        }
        if (options.isUpperCase()) {
            buf.append("UC").append(',');
        }
        if (options.isNoDeclare()) {
            buf.append("NODECLARE").append(',');
        }
        if (options.isNoMethod()) {
            buf.append("NOMETHOD").append(',');
        }
        if (options.isNoConstant()) {
            buf.append("NOCONSTANT").append(',');
        }
        if (options.isDerived()) {
            buf.append("DERIVED").append(',');
        }
        if (options.isFromSuper()) {
            buf.append("SUPER").append(',');
        }
        if (options.isReadOnly()) {
            buf.append("READONLY").append(',');
        }
        if (options.isWriteOnly()) {
            buf.append("WRITEONLY").append(',');
        }
        if (options.getAccessScope() != AccessScope.PUBLIC) {
            buf.append((Object)options.getAccessScope()).append(',');
        }
        if (options.isTrimRead() && options.isTrimWrite()) {
            buf.append("TRIM").append(',');
        } else if (options.isTrimRead()) {
            buf.append("TRIMREAD").append(',');
        } else if (options.isTrimWrite()) {
            buf.append("TRIMWRITE").append(',');
        }
        if (options.isMapNull()) {
            buf.append("MAPNULL").append(',');
        }
        if (options.isSetGet()) {
            buf.append("SETGET").append(',');
        }
        if (options.isNoPrimaryKey()) {
            buf.append("NOPKEY").append(',');
        }
        if (options.isTableSerialProvided()) {
            buf.append("TABLESERIAL").append(',');
        }
        if (options.isTokenLockProvided()) {
            buf.append("TOKENLOCK").append(',');
        }
        if (options.isNormTextProvided()) {
            buf.append("NORMTEXT").append(',');
        }
        if (this.entity.getSuperEntityName() == null && options.isRoot() != this.entity.isRootEntityAccordingToModel()) {
            if (!options.isRoot()) {
                buf.append('!');
            }
            buf.append("ROOT").append(',');
        }
        ModelDefaults modelDefaults = this.configuration.getModelDefaults();
        if (options.noModelDefaults() || modelDefaults == null) {
            if (options.isMaxCol()) {
                buf.append("SIZE").append(',');
            }
            if (options.isBind()) {
                buf.append("BIND").append(',');
            }
            if (options.getTrackType() != TrackType.NONE) {
                buf.append((Object)options.getTrackType()).append(',');
            }
            if (options.isAutoSelect()) {
                buf.append("AUTOSELECT").append(',');
            }
            if (options.isRootIdProvided() != this.entity.isProvidingRootIdAccordingToModel()) {
                if (!options.isRootIdProvided()) {
                    buf.append('!');
                }
                buf.append("ROOTID").append(',');
            }
            if (options.isRootClassIdProvided() != this.entity.isProvidingRootClassIdAccordingToModel()) {
                if (!options.isRootClassIdProvided()) {
                    buf.append('!');
                }
                buf.append("ROOTCLASSID").append(',');
            }
            if (options.isRemote()) {
                buf.append("REMOTE").append(',');
            }
        } else {
            this.printBool(buf, "SIZE", options.isMaxCol(), modelDefaults.getSize());
            this.printBool(buf, "BIND", options.isBind(), modelDefaults.getBind());
            if (modelDefaults.getTrackType() == null && options.getTrackType() != TrackType.NONE || !Objects.equals((Object)modelDefaults.getTrackType(), (Object)options.getTrackType())) {
                buf.append((Object)options.getTrackType()).append(',');
            }
            this.printBool(buf, "AUTOSELECT", options.isAutoSelect(), modelDefaults.getAutoSelect());
            if (modelDefaults.getRootId() != null) {
                this.printBool(buf, "ROOTID", options.isRootIdProvided(), modelDefaults.getRootId() != false && this.entity.isProvidingRootIdAccordingToModel());
            } else {
                this.printBool(buf, "ROOTID", options.isRootIdProvided(), this.entity.isProvidingRootIdAccordingToModel());
            }
            if (modelDefaults.getRootClassId() != null) {
                this.printBool(buf, "ROOTCLASSID", options.isRootClassIdProvided(), modelDefaults.getRootClassId() != false && this.entity.isProvidingRootClassIdAccordingToModel());
            } else {
                this.printBool(buf, "ROOTCLASSID", options.isRootClassIdProvided(), this.entity.isProvidingRootClassIdAccordingToModel());
            }
            this.printBool(buf, "REMOTE", options.isRemote(), modelDefaults.getRemote());
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        if (options.getSorting() != null && !options.getSorting().isEmpty()) {
            buf.append(" |");
            for (String sort : options.getSorting()) {
                buf.append(' ').append(sort);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    private void printBool(StringBuilder buf, String name, boolean optionValue, Boolean defaultValue) {
        if (defaultValue == null && optionValue || defaultValue != null && defaultValue != optionValue) {
            if (!optionValue) {
                buf.append('!');
            }
            buf.append(name).append(',');
        }
    }
}

