/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.tentackle.common.Compare;
import org.tentackle.common.StringHelper;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactory;
import org.tentackle.model.Entity;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.TrackType;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.AttributeOptionsImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.parse.OptionParser;
import org.tentackle.model.parse.RelationLine;

public class RelationImpl
implements Relation,
Comparable<RelationImpl> {
    public static final String DEFAULT = "default";
    public static final String RELATION = "relation";
    public static final String SELECT = "select";
    public static final String DELETE = "delete";
    public static final String LINK = "link";
    public static final String ARGS = "args";
    public static final String NM = "nm";
    public static final String METHOD = "method";
    public static final String NAME = "name";
    public static final String SCOPE = "scope";
    public static final String COMMENT = "comment";
    public static final String COUNT = "count";
    public static final String COMPOSITE = "composite";
    public static final String TRACKED = "tracked";
    public static final String REFERENCED = "referenced";
    public static final String PROCESSED = "processed";
    public static final String READONLY = "readonly";
    public static final String WRITEONLY = "writeonly";
    public static final String NOMETHOD = "nomethod";
    public static final String SERIALIZED = "serialized";
    public static final String REMOTECLEAR = "remoteclear";
    public static final String REVERSED = "reversed";
    public static final String SHALLOW = "shallow";
    public static final String IMMUTABLE = "immutable";
    public static final String PART_OF_NORMTEXT = "normtext";
    public static final String CACHED = "cached";
    public static final String CASCADE = "cascade";
    private final Entity entity;
    private final SourceInfo sourceInfo;
    private int ordinal;
    private List<String> annotations;
    private RelationLine sourceLine;
    private String name;
    private String comment;
    private String className;
    private RelationType relationType;
    private AccessScope accessScope;
    private boolean composite;
    private boolean tracked;
    private boolean referenced;
    private boolean processed;
    private boolean readOnly;
    private boolean writeOnly;
    private boolean serialized;
    private boolean clearOnRemoteSave;
    private boolean reversed;
    private boolean shallow;
    private boolean immutable;
    private boolean partOfNormText;
    private Attribute countAttribute;
    private SelectionType selectionType;
    private boolean selectionCached;
    private String selectionWurbletArguments;
    private String methodName;
    private List<String> args;
    private List<MethodArgument> methodArgs;
    private String nmName;
    private String nmMethodName;
    private String linkMethodName;
    private String linkMethodIndex;
    private boolean deletionFromMainClass;
    private boolean deletionCascaded;
    private Entity foreignEntity;
    private Attribute attribute;
    private Attribute foreignAttribute;
    private Relation foreignRelation;
    private Relation nmRelation;
    private Relation definingNmRelation;
    private boolean deepReference;

    public RelationImpl(Entity entity, SourceInfo sourceInfo) {
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.annotations = new ArrayList<String>();
        this.methodArgs = new ArrayList<MethodArgument>();
        this.accessScope = AccessScope.PUBLIC;
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public ModelElement getParent() {
        return this.getEntity();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.entity);
        hash = 31 * hash + Objects.hashCode(this.name);
        hash = 31 * hash + Objects.hashCode(this.foreignEntity);
        hash = 31 * hash + Objects.hashCode(this.attribute);
        hash = 31 * hash + Objects.hashCode(this.foreignAttribute);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationImpl other = (RelationImpl)obj;
        if (!Objects.equals(this.entity, other.entity)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.foreignEntity, other.foreignEntity)) {
            return false;
        }
        if (!Objects.equals(this.attribute, other.attribute)) {
            return false;
        }
        return Objects.equals(this.foreignAttribute, other.foreignAttribute);
    }

    @Override
    public int compareTo(RelationImpl o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        int rv = Compare.compare((Comparable)((EntityImpl)this.entity), (Comparable)((EntityImpl)o.entity));
        if (rv == 0 && (rv = Compare.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name))) == 0 && (rv = Compare.compare((Comparable)((EntityImpl)this.foreignEntity), (Comparable)((EntityImpl)o.foreignEntity))) == 0 && (rv = Compare.compare((Comparable)((AttributeImpl)this.attribute), (Comparable)((AttributeImpl)o.attribute))) == 0) {
            rv = Compare.compare((Comparable)((AttributeImpl)this.foreignAttribute), (Comparable)((AttributeImpl)o.foreignAttribute));
        }
        return rv;
    }

    public void parse(Entity entity, RelationLine line) throws ModelException {
        this.setSourceLine(line);
        this.setClassName(line.getClassName());
        block76: for (Map.Entry<String, String> entry : line.getProperties().entrySet()) {
            String prop = entry.getKey();
            if (prop.startsWith("@")) {
                this.getAnnotations().add(prop);
                continue;
            }
            StringTokenizer stok = new StringTokenizer(entry.getValue());
            switch (prop.toLowerCase()) {
                case "default": {
                    continue block76;
                }
                case "relation": {
                    block77: while (stok.hasMoreTokens()) {
                        String token = stok.nextToken();
                        switch (token.toLowerCase()) {
                            case "composite": {
                                this.setComposite(true);
                                continue block77;
                            }
                            case "tracked": {
                                this.setTracked(true);
                                continue block77;
                            }
                            case "referenced": {
                                this.setReferenced(true);
                                continue block77;
                            }
                            case "processed": {
                                this.setProcessed(true);
                                continue block77;
                            }
                            case "readonly": {
                                this.setReadOnly(true);
                                continue block77;
                            }
                            case "writeonly": {
                                this.setWriteOnly(true);
                                continue block77;
                            }
                            case "nomethod": {
                                this.setReadOnly(true);
                                this.setWriteOnly(true);
                                continue block77;
                            }
                            case "serialized": {
                                this.setSerialized(true);
                                continue block77;
                            }
                            case "remoteclear": {
                                this.setClearOnRemoteSave(true);
                                continue block77;
                            }
                            case "reversed": {
                                this.setReversed(true);
                                continue block77;
                            }
                            case "shallow": {
                                this.setShallow(true);
                                continue block77;
                            }
                            case "immutable": {
                                this.setImmutable(true);
                                continue block77;
                            }
                            case "normtext": {
                                this.setPartOfNormText(true);
                                continue block77;
                            }
                        }
                        try {
                            this.setRelationType(RelationType.valueOf(token.toUpperCase()));
                        }
                        catch (IllegalArgumentException ex) {
                            throw this.createModelException("illegal keyword in relation property: " + token);
                        }
                    }
                    continue block76;
                }
                case "select": {
                    String token;
                    boolean pipeFound = false;
                    block78: while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        if (token.startsWith("|")) {
                            if (token.length() > 1) {
                                token = token.substring(1);
                            }
                            pipeFound = true;
                        }
                        if (pipeFound) {
                            if (this.selectionWurbletArguments == null) {
                                this.selectionWurbletArguments = token;
                                continue;
                            }
                            this.selectionWurbletArguments = this.selectionWurbletArguments + " " + token;
                            continue;
                        }
                        switch (token.toLowerCase()) {
                            case "cached": {
                                this.setSelectionCached(true);
                                continue block78;
                            }
                        }
                        try {
                            this.setSelectionType(SelectionType.valueOf(token.toUpperCase()));
                        }
                        catch (IllegalArgumentException ex) {
                            throw this.createModelException("illegal keyword in select property: " + token);
                        }
                    }
                    continue block76;
                }
                case "delete": {
                    String token;
                    block79: while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        switch (token.toLowerCase()) {
                            case "cascade": {
                                this.setDeletionCascaded(true);
                                continue block79;
                            }
                        }
                        throw this.createModelException("illegal keyword in delete property: " + token);
                    }
                    continue block76;
                }
                case "link": {
                    String token;
                    while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        if (this.linkMethodName == null) {
                            this.setLinkMethodName(token);
                            continue;
                        }
                        if (this.linkMethodIndex == null) {
                            this.setLinkMethodIndex(token);
                            continue;
                        }
                        throw this.createModelException("illegal keyword in link property: " + token);
                    }
                    continue block76;
                }
                case "args": {
                    String nextArg;
                    OptionParser op = new OptionParser(entry.getValue(), false);
                    while ((nextArg = op.nextOption(1)) != null) {
                        if (this.args == null) {
                            this.args = new ArrayList<String>();
                        }
                        this.args.add(nextArg);
                    }
                    continue block76;
                }
                case "method": {
                    this.setMethodName(entry.getValue());
                    continue block76;
                }
                case "nm": {
                    this.setNmName(stok.nextToken());
                    if (!stok.hasMoreTokens()) continue block76;
                    this.setNmMethodName(stok.nextToken());
                    continue block76;
                }
                case "name": {
                    this.setName(entry.getValue());
                    continue block76;
                }
                case "scope": {
                    try {
                        this.setAccessScope(AccessScope.valueOf(entry.getValue().toUpperCase()));
                        continue block76;
                    }
                    catch (IllegalArgumentException ex) {
                        throw this.createModelException("illegal keyword in scope property: " + entry.getValue());
                    }
                }
                case "count": {
                    Attribute ca = entity.getAttributeByJavaName(entry.getValue(), false);
                    if (ca == null) {
                        throw this.createModelException("unknown counter attribute: " + entry.getValue());
                    }
                    if (!ca.getDataType().isNumeric()) {
                        throw this.createModelException("counter attribute " + ca + " must be numeric");
                    }
                    if (ca.isNullable()) {
                        throw this.createModelException("counter attribute " + ca + " must not be nullable");
                    }
                    ((AttributeOptionsImpl)ca.getOptions()).setHidden(true);
                    this.setCountAttribute(ca);
                    continue block76;
                }
                case "comment": {
                    this.setComment(entry.getValue());
                    continue block76;
                }
            }
            throw this.createModelException("unknown property: " + prop);
        }
        if (this.getRelationType() == RelationType.LIST) {
            this.methodArgs.add(new MethodArgument(this, entity.getAttributeByJavaName("id", true)));
        } else {
            this.methodArgs.add(new MethodArgument(this, entity.getAttributeByJavaName(this.getVariableName() + "Id", true)));
        }
        if (this.args != null) {
            for (String arg : this.args) {
                int ndx = arg.indexOf(91);
                if (ndx < 0) {
                    throw this.createModelException("invalid syntax: " + arg);
                }
                String foreignName = arg.substring(0, ndx).trim();
                String attribName = arg.substring(ndx + 1);
                if (attribName.endsWith("]")) {
                    attribName = attribName.substring(0, attribName.length() - 1);
                }
                if (attribName.endsWith("()")) {
                    if ((attribName = attribName.substring(0, attribName.length() - 2)).startsWith("is")) {
                        attribName = attribName.substring(2);
                    } else if (attribName.startsWith("get")) {
                        attribName = attribName.substring(3);
                    } else {
                        throw this.createModelException("invalid method name: " + arg);
                    }
                    this.methodArgs.add(new MethodArgument((Relation)this, foreignName, entity.getAttributeByJavaName(attribName, true)));
                    continue;
                }
                this.methodArgs.add(new MethodArgument((Relation)this, foreignName, attribName));
            }
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    @Override
    public String getGetterSetterComment() {
        StringBuilder buf = new StringBuilder();
        if (this.reversed) {
            buf.append("reversed as 1:1 from ").append(this.entity);
        } else {
            buf.append(this.getVariableName());
        }
        if (this.deepReference) {
            buf.append(" deeply");
        }
        buf.append(" via ");
        if (this.attribute != null || this.foreignAttribute != null) {
            if (this.attribute != null) {
                buf.append(this.attribute);
            } else {
                buf.append(this.foreignEntity).append('#').append(this.foreignAttribute);
            }
        } else if (!this.methodArgs.isEmpty()) {
            buf.append(this.methodArgs.get(0));
        }
        if (this.methodArgs.size() > 1) {
            boolean firstSkipped = false;
            for (MethodArgument methodArg : this.methodArgs) {
                if (firstSkipped) {
                    buf.append(" & ").append(methodArg.getForeignAttribute());
                }
                firstSkipped = true;
            }
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.composite) {
            buf.append("composite ");
        }
        if (this.getRelationType() == RelationType.LIST && !this.reversed) {
            buf.append("list of ");
        }
        if (this.foreignEntity != null) {
            buf.append(this.foreignEntity).append(" ");
            buf.append(this.getGetterSetterComment());
        } else {
            buf.append('?').append(this.getName()).append('?');
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            buf.append(" (").append(this.comment).append(')');
        }
        return buf.toString();
    }

    @Override
    public void validate() throws ModelException {
        this.getRelationType();
        if (this.className == null) {
            throw this.createModelException("missing classname");
        }
        if (this.accessScope == null) {
            throw this.createModelException("missing access scope");
        }
        if (this.selectionType == null) {
            SelectionType selectionType = this.selectionType = this.selectionCached ? SelectionType.ALWAYS : SelectionType.LAZY;
        }
        if (this.composite) {
            if (this.selectionType != SelectionType.LAZY && this.selectionType != SelectionType.EAGER) {
                throw this.createModelException("composite relations must be eager or lazy");
            }
        } else if (this.immutable) {
            throw this.createModelException("immutable relations must be composite");
        }
        if (this.reversed && (this.composite || this.relationType != RelationType.LIST)) {
            throw this.createModelException("reversed 1:1 mapping only allowed for non-composite list relations");
        }
        if (this.relationType == RelationType.LIST) {
            if (this.selectionCached) {
                throw this.createModelException("cached select is not allowed for list relations");
            }
            if (this.deletionCascaded && !this.composite) {
                throw this.createModelException("cascaded delete is not allowed for non-composite list relations");
            }
        } else {
            if (this.linkMethodIndex != null) {
                throw this.createModelException("indexed link method is not allowed for object relations");
            }
            if (this.deletionCascaded) {
                throw this.createModelException("object relations are always deleted cascaded");
            }
            if (this.linkMethodName != null && !this.referenced) {
                throw this.createModelException("object relations with link= option must be referenced");
            }
            if (this.methodArgs.size() > 1) {
                throw this.createModelException("object relations cannot have extra args");
            }
        }
        if (this.composite && this.selectionCached) {
            throw this.createModelException("cached select is not allowed for composite relations");
        }
        if (this.processed && !this.composite) {
            throw this.createModelException("processed only allowed for composite relations");
        }
        if (this.serialized) {
            if (this.selectionCached) {
                throw this.createModelException("cached select is not allowed for serialized relations");
            }
            if (this.isComposite() || this.selectionType != SelectionType.LAZY && this.selectionType != SelectionType.EAGER) {
                throw this.createModelException("serialized is only allowed for lazy or eager non-composite relations");
            }
        }
        if (!(this.nmName == null || this.composite && this.relationType != RelationType.OBJECT)) {
            throw this.createModelException("nm-relations must be composite lists");
        }
        if (this.selectionWurbletArguments != null && this.relationType != RelationType.LIST) {
            throw this.createModelException("extra wurblet arguments are only allowed for list relations (in select property): " + this.selectionWurbletArguments);
        }
        if (this.countAttribute != null) {
            if (this.relationType != RelationType.LIST || this.reversed || !this.composite) {
                throw this.createModelException("counter attribute only allowed for composite non-reversed list relations");
            }
            if (this.entity.getOptions().getTrackType() != TrackType.FULLTRACKED) {
                throw this.createModelException("entity must be FULLTRACKED to support counter attributes");
            }
        }
    }

    @Override
    public String getName() {
        return this.name == null ? this.className : this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = StringHelper.firstToUpper((String)name);
        }
        this.name = name;
    }

    public RelationLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(RelationLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this.entity);
        return ex;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public RelationType getRelationType() {
        if (this.relationType == null) {
            this.relationType = this.reversed ? RelationType.LIST : RelationType.OBJECT;
        }
        return this.relationType;
    }

    @Override
    public AccessScope getAccessScope() {
        return this.accessScope;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Entity getForeignEntity() {
        return this.foreignEntity;
    }

    @Override
    public Attribute getForeignAttribute() {
        return this.foreignAttribute;
    }

    @Override
    public Relation getForeignRelation() {
        return this.foreignRelation;
    }

    @Override
    public Relation getNmRelation() {
        return this.nmRelation;
    }

    @Override
    public Relation getDefiningNmRelation() {
        return this.definingNmRelation;
    }

    @Override
    public boolean isComposite() {
        return this.composite;
    }

    @Override
    public boolean isTracked() {
        return this.tracked;
    }

    @Override
    public boolean isReferenced() {
        return this.referenced;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isWriteOnly() {
        return this.writeOnly;
    }

    @Override
    public boolean isSerialized() {
        return this.serialized;
    }

    @Override
    public boolean isClearOnRemoteSave() {
        return this.clearOnRemoteSave;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public boolean isShallow() {
        return this.shallow;
    }

    public void setShallow(boolean shallow) {
        this.shallow = shallow;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    @Override
    public boolean isPartOfNormText() {
        return this.partOfNormText;
    }

    public void setPartOfNormText(boolean partOfNormText) {
        this.partOfNormText = partOfNormText;
    }

    @Override
    public Attribute getCountAttribute() {
        return this.countAttribute;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<MethodArgument> getMethodArgs() {
        return this.methodArgs;
    }

    @Override
    public String getNmName() {
        return this.nmName;
    }

    @Override
    public String getNmMethodName() {
        return this.nmMethodName;
    }

    @Override
    public String getLinkMethodName() {
        return this.linkMethodName;
    }

    @Override
    public String getLinkMethodIndex() {
        return this.linkMethodIndex;
    }

    @Override
    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    @Override
    public boolean isSelectionCached() {
        return this.selectionCached;
    }

    @Override
    public String getSelectionWurbletArguments() {
        return this.selectionWurbletArguments;
    }

    @Override
    public boolean isDeletionFromMainClass() {
        return this.deletionFromMainClass;
    }

    @Override
    public boolean isDeletionCascaded() {
        return this.deletionCascaded;
    }

    public void setNmRelation(Relation nmRelation) {
        this.nmRelation = nmRelation;
    }

    public void setDefiningNmRelation(Relation definingNmRelation) {
        this.definingNmRelation = definingNmRelation;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public void setForeignEntity(Entity foreignEntity) {
        this.foreignEntity = foreignEntity;
    }

    public void setForeignAttribute(Attribute foreignAttribute) {
        this.foreignAttribute = foreignAttribute;
    }

    public void setForeignRelation(Relation foreignRelation) {
        this.foreignRelation = foreignRelation;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public void setLinkMethodName(String linkMethodName) {
        this.linkMethodName = linkMethodName;
    }

    public void setMethodArgs(List<MethodArgument> methodArgs) {
        this.methodArgs = methodArgs;
    }

    public void setNmName(String nmName) {
        this.nmName = nmName;
    }

    public void setNmMethodName(String nmMethodName) {
        this.nmMethodName = nmMethodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setReferenced(boolean referenced) {
        this.referenced = referenced;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setRelationType(RelationType relationType) {
        this.relationType = relationType;
    }

    public void setSerialized(boolean serialized) {
        this.serialized = serialized;
    }

    public void setClearOnRemoteSave(boolean clearOnRemoteSave) {
        this.clearOnRemoteSave = clearOnRemoteSave;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void setCountAttribute(Attribute countAttribute) {
        this.countAttribute = countAttribute;
    }

    public void setTracked(boolean tracked) {
        this.tracked = tracked;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    public void setSelectionType(SelectionType selectionType) {
        this.selectionType = selectionType;
    }

    public void setSelectionCached(boolean selectionCached) {
        this.selectionCached = selectionCached;
    }

    public void setSelectionWurbletArguments(String selectionWurbletArguments) {
        this.selectionWurbletArguments = selectionWurbletArguments;
    }

    public void setAccessScope(AccessScope accessScope) {
        this.accessScope = accessScope;
    }

    public void setDeletionCascaded(boolean deletionCascaded) {
        this.deletionCascaded = deletionCascaded;
    }

    public void setDeletionFromMainClass(boolean deletionFromMainClass) {
        this.deletionFromMainClass = deletionFromMainClass;
    }

    public void setLinkMethodIndex(String linkMethodIndex) {
        this.linkMethodIndex = linkMethodIndex;
    }

    private String buildName(boolean tolower) {
        Object str = this.name == null ? this.className : this.name;
        str = tolower ? StringHelper.firstToLower((String)str) : StringHelper.firstToUpper((String)str);
        if (this.getRelationType() == RelationType.LIST && !this.reversed && this.name == null) {
            str = (String)str + "List";
        }
        return str;
    }

    @Override
    public String getVariableName() {
        return this.buildName(true);
    }

    @Override
    public String getMethodNameSuffix() {
        return this.buildName(false);
    }

    @Override
    public String getGetterName() {
        return CodeFactory.getInstance().createGetterName(this);
    }

    @Override
    public String getSetterName() {
        return CodeFactory.getInstance().createSetterName(this);
    }

    @Override
    public String getDeclaredJavaType(boolean withinForeignEntity) {
        return CodeFactory.getInstance().createDeclaredJavaType(this, withinForeignEntity);
    }

    @Override
    public String getJavaType() {
        return CodeFactory.getInstance().createJavaType(this);
    }

    @Override
    public boolean isDeepReference() {
        return this.deepReference;
    }

    public void setDeepReference(boolean deepReference) {
        this.deepReference = deepReference;
    }
}

