/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.model.ModelException;
import org.tentackle.model.parse.Document;
import org.tentackle.model.parse.LineType;
import org.tentackle.model.parse.OptionParser;
import org.tentackle.model.parse.SingleLine;

public class GlobalOptionLine
extends SingleLine {
    private List<String> options;
    private List<String> sortings;

    public GlobalOptionLine(Document document, int offset, LineType lineType) {
        super(document, offset, lineType);
    }

    @Override
    public void parse() throws ModelException {
        String option;
        super.parse();
        Object optionsText = this.getText();
        String sortingText = null;
        int ndx = ((String)optionsText).lastIndexOf(124);
        if (ndx >= 0 && ((String)optionsText).length() > ndx) {
            boolean endsWithBracket = ((String)optionsText).endsWith("]");
            sortingText = ((String)optionsText).substring(ndx + 1);
            optionsText = ((String)optionsText).substring(0, ndx);
            if (endsWithBracket) {
                optionsText = (String)optionsText + "]";
                sortingText = sortingText.substring(0, sortingText.length() - 1);
            }
        }
        OptionParser parser = new OptionParser((String)optionsText, true);
        this.options = new ArrayList<String>();
        while ((option = parser.nextOption()) != null) {
            this.options.add(option);
        }
        this.sortings = new ArrayList<String>();
        if (sortingText != null) {
            StringTokenizer stok = new StringTokenizer(sortingText);
            while (stok.hasMoreTokens()) {
                this.sortings.add(stok.nextToken());
            }
        }
    }

    public List<String> getOptions() throws ModelException {
        this.assertParsed();
        return this.options;
    }

    public List<String> getSortings() throws ModelException {
        this.assertParsed();
        return this.sortings;
    }
}

