/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.model.ModelException;
import org.tentackle.model.parse.Document;
import org.tentackle.model.parse.LineType;
import org.tentackle.model.parse.MultiLine;
import org.tentackle.model.parse.OptionParser;

public class OptionLine
extends MultiLine {
    private String name;
    private List<String> options;

    public OptionLine(Document document, int offset, LineType lineType) {
        super(document, offset, lineType);
    }

    @Override
    public void parse() throws ModelException {
        String option;
        super.parse();
        String text = this.getText();
        int ndx = text.indexOf(58);
        if (ndx < 0) {
            throw this.createModelException("missing colon (:)");
        }
        this.name = text.substring(0, ndx).trim();
        if (this.name.length() == 0) {
            throw this.createModelException("missing attribute name");
        }
        String optionText = text.substring(ndx + 1);
        this.options = new ArrayList<String>();
        OptionParser parser = new OptionParser(optionText, false);
        while ((option = parser.nextOption()) != null) {
            this.options.add(option.trim());
        }
    }

    public String getName() throws ModelException {
        this.assertParsed();
        return this.name;
    }

    public List<String> getOptions() throws ModelException {
        this.assertParsed();
        return this.options;
    }
}

