/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import java.util.List;
import java.util.Objects;
import org.tentackle.common.StringHelper;
import org.tentackle.model.AccessScope;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.print.AnnotationPrinter;
import org.tentackle.model.print.PrintConfiguration;

public class RelationPrinter {
    private final Relation relation;
    private final PrintConfiguration configuration;

    public RelationPrinter(Relation relation, PrintConfiguration configuration) {
        this.relation = relation;
        this.configuration = configuration;
    }

    public String print() {
        List<String> annotations;
        StringBuilder buf = new StringBuilder();
        if (!StringHelper.isAllWhitespace((String)this.relation.getComment()) && !this.relation.getComment().equals(this.relation.getName())) {
            if (this.configuration.isPrintingAsComment()) {
                buf.append(" * ");
            }
            buf.append("# ").append(this.relation.getComment()).append('\n');
        }
        if (this.configuration.isPrintingAsComment()) {
            buf.append(" * ");
        }
        buf.append(this.relation.getClassName()).append(":\n");
        boolean needComma = false;
        if (this.relation.getRelationType() != RelationType.OBJECT || this.relation.isReversed() || this.relation.isComposite() || this.relation.isReferenced() || this.relation.isProcessed() || this.relation.isSerialized() && !this.relation.isComposite() || this.relation.isClearOnRemoteSave() || this.relation.isTracked() && !this.relation.getEntity().isTracked()) {
            this.lead(buf).append("relation").append(" =");
            if (this.relation.isComposite()) {
                buf.append(' ').append("composite");
            }
            if (this.relation.isTracked() && !this.relation.getEntity().isTracked()) {
                buf.append(' ').append("tracked");
            }
            if (this.relation.isReferenced()) {
                buf.append(' ').append("referenced");
            }
            if (this.relation.isProcessed()) {
                buf.append(' ').append("processed");
            }
            if (this.relation.isSerialized() && !this.relation.isComposite()) {
                buf.append(' ').append("serialized");
            }
            if (this.relation.isClearOnRemoteSave()) {
                buf.append(' ').append("remoteclear");
            }
            if (this.relation.isImmutable()) {
                buf.append(' ').append("immutable");
            }
            if (this.relation.isShallow()) {
                buf.append(' ').append("shallow");
            }
            if (this.relation.isPartOfNormText()) {
                buf.append(' ').append("normtext");
            }
            if (this.relation.isReversed()) {
                buf.append(' ').append("reversed");
            } else {
                buf.append(' ').append(this.relation.getRelationType().toString().toLowerCase());
            }
            needComma = true;
        }
        if (this.relation.getSelectionType() != SelectionType.LAZY && !this.relation.isSelectionCached() || this.relation.getSelectionType() != SelectionType.ALWAYS && this.relation.isSelectionCached() || this.relation.isSelectionCached() || this.relation.getSelectionWurbletArguments() != null) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("select").append(" =");
            boolean selectionTypePrinted = false;
            if (this.relation.isSelectionCached()) {
                if (this.relation.getSelectionType() != SelectionType.ALWAYS) {
                    buf.append(' ').append(this.relation.getSelectionType().toString().toLowerCase());
                    selectionTypePrinted = true;
                }
                buf.append(' ').append("cached");
            } else if (this.relation.getSelectionType() != SelectionType.LAZY) {
                buf.append(' ').append(this.relation.getSelectionType().toString().toLowerCase());
                selectionTypePrinted = true;
            }
            if (this.relation.getSelectionWurbletArguments() != null) {
                if (!selectionTypePrinted) {
                    buf.append(' ').append(this.relation.getSelectionType().toString().toLowerCase());
                }
                if (this.relation.getSelectionWurbletArguments().startsWith("|")) {
                    buf.append(' ');
                } else {
                    buf.append(" | ");
                }
                buf.append(this.relation.getSelectionWurbletArguments());
            }
            needComma = true;
        }
        if (this.relation.isDeletionFromMainClass() || this.relation.isDeletionCascaded() && (this.configuration.getModelDefaults() == null || this.configuration.getModelDefaults().getDeletionCascaded() == null || !this.configuration.getModelDefaults().getDeletionCascaded().booleanValue())) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("delete").append(" =");
            if (this.relation.isDeletionCascaded() && (this.configuration.getModelDefaults() == null || this.configuration.getModelDefaults().getDeletionCascaded() == null || !this.configuration.getModelDefaults().getDeletionCascaded().booleanValue())) {
                buf.append(' ').append("cascade");
            }
            needComma = true;
        }
        if (this.relation.getLinkMethodName() != null || this.relation.getLinkMethodIndex() != null) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("link").append(" =");
            if (this.relation.getLinkMethodName() != null) {
                buf.append(' ').append(this.relation.getLinkMethodName());
            }
            if (this.relation.getLinkMethodIndex() != null) {
                buf.append(' ').append(this.relation.getLinkMethodIndex());
            }
            needComma = true;
        }
        if (this.relation.getMethodArgs().size() > 1) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("args").append(" =");
            boolean firstSkipped = false;
            for (MethodArgument arg : this.relation.getMethodArgs()) {
                if (firstSkipped) {
                    buf.append(' ').append(arg.getForeignAttribute()).append('[').append(arg.getMethodArgument()).append(']');
                }
                firstSkipped = true;
            }
            needComma = true;
        }
        if (!Objects.equals(this.relation.getClassName(), this.relation.getName())) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("name").append(" = ").append(this.relation.getName());
            needComma = true;
        }
        if (this.relation.getNmName() != null) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("nm").append(" = ").append(this.relation.getNmName());
            if (this.relation.getNmMethodName() != null) {
                buf.append(' ').append(this.relation.getNmMethodName());
            }
            needComma = true;
        }
        if (this.relation.getAccessScope() != AccessScope.PUBLIC) {
            if (needComma) {
                buf.append(",\n");
            }
            this.lead(buf).append("scope").append(" = ").append(this.relation.getAccessScope().toString().toLowerCase());
            needComma = true;
        }
        if ((annotations = this.relation.getAnnotations()) != null && !annotations.isEmpty()) {
            for (String annotation : annotations) {
                if (needComma) {
                    buf.append(",\n");
                }
                this.lead(buf).append(new AnnotationPrinter(annotation).print());
            }
        }
        if (needComma) {
            buf.append('\n');
        }
        return buf.toString();
    }

    private StringBuilder lead(StringBuilder buf) {
        if (this.configuration.isPrintingAsComment()) {
            buf.append(" * ");
        }
        buf.append("    ");
        return buf;
    }
}

