/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.List;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactory$Singleton;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.sql.Backend;

@Service(value=CodeFactory.class)
public class CodeFactory {
    public static CodeFactory getInstance() {
        return CodeFactory$Singleton.INSTANCE;
    }

    public String createColumnPostfix(String javaType, int index) {
        StringBuilder postfix = new StringBuilder();
        if (index > 0) {
            postfix.append('_').append(index + 1);
        }
        return postfix.toString();
    }

    public String createBindableAnnotation(Attribute attribute) {
        if (attribute.getOptions().isBindable()) {
            String bindOptions = attribute.getOptions().getBindOptions();
            if (StringHelper.isAllWhitespace((String)bindOptions)) {
                return "@Bindable";
            }
            return "@Bindable(options=\"" + bindOptions + "\")";
        }
        return null;
    }

    public String createMethodArgument(Attribute attribute, String value) {
        if (attribute.getDataType().isNumeric()) {
            switch (attribute.getDataType()) {
                case BYTE: {
                    value = "(Byte) " + (String)value;
                    break;
                }
                case BYTE_PRIMITIVE: {
                    value = "(byte) " + (String)value;
                    break;
                }
                case SHORT: {
                    value = "(Short) " + (String)value;
                    break;
                }
                case SHORT_PRIMITIVE: {
                    value = "(short) " + (String)value;
                }
            }
        }
        return value;
    }

    public String createGetterName(Attribute attribute) {
        StringBuilder buf = new StringBuilder();
        if (attribute.getDataType().isBool()) {
            buf.append("is");
        } else {
            buf.append("get");
        }
        buf.append(attribute.getMethodNameSuffix());
        return buf.toString();
    }

    public String createSetterName(Attribute attribute) {
        return "set" + attribute.getMethodNameSuffix();
    }

    public String createGetterName(Relation relation) {
        return "get" + relation.getMethodNameSuffix();
    }

    public String createSetterName(Relation relation) {
        return "set" + relation.getMethodNameSuffix();
    }

    public String createDeclaredJavaType(Relation relation, boolean withinForeignEntity) {
        Object type = relation.getClassName();
        if (relation.getForeignEntity().isAbstract()) {
            type = withinForeignEntity ? "T" : (String)type + "<?>";
        }
        if (relation.getRelationType() == RelationType.LIST && !relation.isReversed()) {
            return (relation.isTracked() ? "TrackedList" : "List") + "<" + (String)type + ">";
        }
        return type;
    }

    public String createJavaType(Relation relation) {
        if (relation.getRelationType() == RelationType.LIST && !relation.isReversed()) {
            return (relation.isTracked() ? "TrackedArrayList" : "ArrayList") + "<>";
        }
        return relation.getClassName();
    }

    public String createSqlTable(Entity entity, Backend backend) throws ModelException {
        StringBuilder buf = new StringBuilder();
        buf.append(backend.sqlCreateTableIntro(entity.getTableName(), entity.getOptions().getComment()));
        List<Attribute> tableAttributes = entity.getTableAttributes();
        int attributeNum = tableAttributes.size();
        int attributeCount = 1;
        for (Attribute attribute : tableAttributes) {
            DataType dataType = attribute.getEffectiveType();
            int multiColumnIndex = 1;
            int multiColumnSize = dataType.getSqlTypes().length;
            for (DataType.SqlTypeWithPostfix sp : dataType.getSqlTypesWithPostfix()) {
                buf.append("    ");
                String columnName = attribute.getColumnName() + sp.getPostfix();
                int size = attribute.getSizeWithDefault();
                int scale = attribute.getScaleWithDefault();
                Object defaultValue = attribute.getOptions().getDefaultValue();
                String comment = attribute.getOptions().getComment();
                if (multiColumnIndex > 1) {
                    comment = null;
                    if (defaultValue != null) {
                        defaultValue = sp.getSqlType().getDefaultValue();
                    }
                }
                if (dataType.isScaleInSecondColumn()) {
                    if (multiColumnIndex == 2) {
                        size = 0;
                    }
                    scale = 0;
                }
                buf.append(backend.sqlCreateColumn(columnName, comment, sp.getSqlType(), size, scale, attribute.isNullable(), defaultValue, attribute.getName().equals("id") && !entity.getOptions().isNoPrimaryKey(), attributeCount < attributeNum || multiColumnIndex < multiColumnSize));
                ++multiColumnIndex;
            }
            ++attributeCount;
        }
        buf.append(backend.sqlCreateTableClosing(entity.getTableName(), entity.getOptions().getComment()));
        buf.append(backend.sqlCreateTableComment(entity.getTableName(), entity.getOptions().getComment()));
        for (Attribute attribute : tableAttributes) {
            buf.append(backend.sqlCreateColumnComment(entity.getTableName(), attribute.getColumnName(), attribute.getOptions().getComment()));
        }
        return buf.toString();
    }

    public String createSqlIndex(Backend backend, Entity entity, Index index) {
        StringBuilder buf = new StringBuilder();
        if (index.getComment() != null) {
            buf.append("-- ");
            buf.append(index.getComment());
            buf.append('\n');
        }
        String[] columnNames = new String[index.getAttributes().size()];
        int attributeCount = 0;
        for (IndexAttribute indexAttribute : index.getAttributes()) {
            Object indexPart = indexAttribute.getFunctionName() != null ? indexAttribute.getFunctionName() + "(" + indexAttribute.getAttribute().getColumnName() + ")" : indexAttribute.getAttribute().getColumnName();
            columnNames[attributeCount] = indexAttribute.isDescending() ? "-" + (String)indexPart : indexPart;
            ++attributeCount;
        }
        buf.append(backend.sqlCreateIndex(entity.getTableName(), index.createDatabaseIndexName(entity), index.isUnique(), index.getFilterCondition(), columnNames));
        return buf.toString();
    }

    public String createSqlForeignKey(ForeignKey foreignKey, Backend backend) {
        return backend.sqlCreateForeignKey(foreignKey.getReferencingTableProvidingEntity().getTableName(), foreignKey.getReferencingAttribute().getColumnName(), foreignKey.getReferencedTableProvidingEntity().getTableName(), foreignKey.getReferencedAttribute().getColumnName(), foreignKey.getReferencingEntity().getTableAlias() + "_" + foreignKey.getReferencingAttribute().getColumnName() + "_fkey", foreignKey.isComposite() && foreignKey.getReferencingEntity().getIntegrity().isCompositesCheckedByDatabase());
    }
}

