/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.NameVerifier;

@Service(value=NameVerifier.class)
public class NameVerifierImpl
implements NameVerifier {
    private static final String TABLE_NAME = "table name '";
    private static final String TABLE_ALIAS = "table alias '";
    private static final String COLUMN_NAME = "column name '";
    private static final String MIXED_UC_LC = "' contains mixed upper- and lowercase characters";
    private static final String QUOTED = "' is quoted, which is only allowed for [PROVIDED] entities";

    @Override
    public String verifyEntityName(Entity entity) {
        String name = entity.getName();
        return StringHelper.isValidJavaClassName((String)name) ? null : "'" + name + "' is not a valid Java class name";
    }

    @Override
    public String verifyTableName(Entity entity) {
        String name = entity.getTableName();
        if (this.isNotQuotedOrProvided(name, entity)) {
            return this.isAllUpperOrLowerCase(name, entity) ? null : TABLE_NAME + name + MIXED_UC_LC;
        }
        return TABLE_NAME + name + QUOTED;
    }

    @Override
    public String verifyTableAlias(Entity entity) {
        String name = entity.getTableAlias();
        if (this.isNotQuotedOrProvided(name, entity)) {
            return this.isAllUpperOrLowerCase(name, entity) ? null : TABLE_ALIAS + name + MIXED_UC_LC;
        }
        return TABLE_ALIAS + name + QUOTED;
    }

    @Override
    public String verifyAttributeName(Attribute attribute) {
        String name = attribute.getName();
        return StringHelper.isValidJavaIdentifier((String)name) ? null : "'" + name + "' is not a valid Java identifier name";
    }

    @Override
    public String verifyColumnName(Attribute attribute) {
        String name = attribute.getColumnName();
        if (this.isNotQuotedOrProvided(name, attribute.getEntity())) {
            return this.isAllUpperOrLowerCase(name, attribute.getEntity()) ? null : COLUMN_NAME + name + MIXED_UC_LC;
        }
        return COLUMN_NAME + name + QUOTED;
    }

    @Override
    public String verifyIndexName(Index index) {
        String name = index.getName();
        return this.isAllUpperOrLowerCase(name, index.getEntity()) ? null : "index name '" + name + MIXED_UC_LC;
    }

    protected boolean isAllUpperOrLowerCase(String name, Entity entity) {
        return name == null || entity.getOptions().isProvided() || name.equals(name.toLowerCase()) || name.equals(name.toUpperCase());
    }

    protected boolean isNotQuotedOrProvided(String name, Entity entity) {
        return name == null || !name.startsWith("\"") || entity.getOptions().isProvided();
    }
}

