/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeOptions;
import org.tentackle.model.EntityOptions;
import org.tentackle.model.ModelException;
import org.tentackle.model.print.AnnotationPrinter;
import org.tentackle.model.print.PrintConfiguration;

public class AttributeOptionsPrinter {
    private final Attribute attribute;
    private final PrintConfiguration configuration;

    public AttributeOptionsPrinter(Attribute attribute, PrintConfiguration configuration) {
        this.attribute = attribute;
        this.configuration = configuration;
    }

    public String print() {
        StringBuilder buf = new StringBuilder();
        EntityOptions entityOptions = this.attribute.getEntity().getOptions();
        AttributeOptions options = this.attribute.getOptions();
        buf.append(this.printBindOptions());
        if (this.attribute.getDataType().isNumeric() || this.attribute.getDataType().isDateOrTime()) {
            this.printBool(buf, "AUTOSELECT", options.isAutoSelect(), entityOptions.isAutoSelect());
        }
        this.printBool(buf, "BIND", options.isBindable(), entityOptions.isBindable());
        this.printBool(buf, "NODECLARE", options.isNoDeclare(), entityOptions.isNoDeclare());
        this.printBool(buf, "NOMETHOD", options.isNoMethod(), entityOptions.isNoMethod());
        this.printBool(buf, "NOCONSTANT", options.isNoConstant(), entityOptions.isNoConstant());
        this.printBool(buf, "MUTE", options.isMute(), entityOptions.isMute());
        this.printBool(buf, "SUPER", options.isFromSuper(), entityOptions.isFromSuper());
        this.printBool(buf, "READONLY", options.isReadOnly(), entityOptions.isReadOnly());
        this.printBool(buf, "WRITEONLY", options.isWriteOnly(), entityOptions.isWriteOnly());
        this.printBool(buf, "MAPNULL", options.isMapNull(), entityOptions.isMapNull());
        if (options.isTrimRead() == options.isTrimWrite() && entityOptions.isTrimRead() == entityOptions.isTrimWrite()) {
            this.printBool(buf, "TRIM", options.isTrimRead(), entityOptions.isTrimRead());
        } else {
            this.printBool(buf, "TRIMREAD", options.isTrimRead(), entityOptions.isTrimRead());
            this.printBool(buf, "TRIMWRITE", options.isTrimWrite(), entityOptions.isTrimWrite());
        }
        if (options.getAccessScope() != entityOptions.getAccessScope()) {
            buf.append((Object)options.getAccessScope()).append(',');
        }
        this.printBool(buf, "CONTEXT", options.isContextId());
        this.printBool(buf, "KEY", options.isDomainKey());
        this.printBool(buf, "TZ", options.isWithTimezone());
        this.printBool(buf, "HIDDEN", options.isHidden());
        this.printBool(buf, "SHALLOW", options.isShallow());
        this.printBool(buf, "NORMTEXT", options.isPartOfNormText());
        if (options.getDefaultValue() != null) {
            buf.append("DEFAULT").append(' ');
            try {
                buf.append(this.attribute.getEffectiveType().print(options.getDefaultValue()));
            }
            catch (ModelException mx) {
                buf.append("?").append(mx.getMessage()).append("?");
            }
            buf.append(',');
        }
        if (options.getInitialValue() != null) {
            buf.append("INIT").append(' ').append(options.getInitialValue()).append(',');
        }
        for (String anno : options.getAnnotations()) {
            if (!this.configuration.isOptionAnnotation(anno)) continue;
            buf.append(new AnnotationPrinter(anno).print()).append(',');
        }
        for (String stereotype : options.getStereotypes()) {
            buf.append('#').append(stereotype).append(',');
        }
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private String printBindOptions() {
        String attributeOptions;
        HashSet<String> entityOptionSet = new HashSet<String>();
        HashSet<String> attributeOptionSet = new HashSet<String>();
        String entityOptions = this.attribute.getEntity().getOptions().getBindOptions();
        if (entityOptions != null && !entityOptions.isEmpty()) {
            StringTokenizer stok = new StringTokenizer(entityOptions, ",");
            while (stok.hasMoreTokens()) {
                entityOptionSet.add(stok.nextToken());
            }
        }
        if ((attributeOptions = this.attribute.getOptions().getBindOptions()) != null && !attributeOptions.isEmpty()) {
            StringTokenizer stok = new StringTokenizer(attributeOptions, ",");
            while (stok.hasMoreTokens()) {
                String option = stok.nextToken();
                if (option.startsWith("MAXCOLS")) {
                    int maxCol = Integer.parseInt(option.substring("MAXCOLS".length() + 1));
                    if (this.attribute.getSize() != null && this.attribute.getSize() == maxCol) continue;
                }
                if (option.startsWith("SCALE")) {
                    int scale = Integer.parseInt(option.substring("SCALE".length() + 1));
                    if (this.attribute.getScale() != null && this.attribute.getScale() == scale) continue;
                }
                attributeOptionSet.add(option);
            }
        }
        StringBuilder buf = new StringBuilder();
        for (String option : attributeOptionSet) {
            if (entityOptionSet.contains(option)) continue;
            buf.append(option).append(',');
        }
        return buf.toString();
    }

    private void printBool(StringBuilder buf, String name, boolean optionValue, boolean entityValue) {
        if (optionValue != entityValue) {
            if (!optionValue) {
                buf.append('!');
            }
            buf.append(name).append(',');
        }
    }

    private void printBool(StringBuilder buf, String name, boolean optionValue) {
        this.printBool(buf, name, optionValue, false);
    }
}

