/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeSorting;
import org.tentackle.model.EntityOptions;
import org.tentackle.model.Index;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Integrity;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.sql.Backend;

public interface Entity
extends ModelElement {
    public int getClassId();

    public String getTableName();

    public String getSchemaName();

    public String getTableNameWithoutSchema();

    public String getTableAlias();

    public String getDefinedTableAlias();

    public Integrity getIntegrity();

    public EntityOptions getOptions();

    public List<Attribute> getAttributes();

    public List<Attribute> getInheritedAttributes();

    public List<Attribute> getSubEntityAttributes();

    public List<Attribute> getAttributesIncludingInherited();

    public List<Attribute> getAttributesIncludingSubEntities();

    public List<Attribute> getAllAttributes();

    public List<Attribute> getTableAttributes();

    public List<Attribute> getMappedAttributes();

    public Attribute getAttributeByJavaName(String var1, boolean var2);

    public Attribute getAttributeByColumnName(String var1, boolean var2);

    public Attribute getContextIdAttribute();

    public List<Attribute> getUniqueDomainKey();

    public List<AttributeSorting> getSorting();

    public List<Relation> getRelations();

    public List<Relation> getInheritedRelations();

    public List<Relation> getSubEntityRelations();

    public List<Relation> getRelationsIncludingInherited();

    public List<Relation> getRelationsIncludingSubEntities();

    public List<Relation> getAllRelations();

    public List<Relation> getTableRelations();

    public Relation getRelation(String var1, boolean var2);

    public List<Relation> getRelations(Entity var1, boolean var2);

    public List<Relation> getReferencingRelations();

    public List<Relation> getInheritedReferencingRelations();

    public List<Relation> getSubEntityReferencingRelations();

    public List<Relation> getReferencingRelationsIncludingInherited();

    public List<Relation> getReferencingRelationsIncludingSubEntities();

    public List<Relation> getAllReferencingRelations();

    public List<Index> getIndexes();

    public List<Index> getInheritedIndexes();

    public List<Index> getSubEntityIndexes();

    public List<Index> getIndexesIncludingInherited();

    public List<Index> getIndexesIncludingSubEntities();

    public List<Index> getAllIndexes();

    public List<Index> getTableIndexes();

    public Index getIndex(String var1, boolean var2);

    public String sqlCreateTable(Backend var1) throws ModelException;

    public boolean isComposite();

    public boolean isAbstract();

    public boolean isTracked();

    public Boolean isDeletionCascaded();

    public Set<Attribute> getRootAttributes();

    public Attribute getRootAttribute();

    public Set<Entity> getRootEntities();

    public Entity getRootEntity();

    public boolean isRootEntity();

    public boolean isRootOfInheritanceHierarchy();

    public Entity getTableProvidingEntity();

    public InheritanceType getInheritanceType();

    public InheritanceType getHierarchyInheritanceType();

    public String getSuperEntityName();

    public Entity getSuperEntity();

    public List<Entity> getSuperEntities();

    public Entity getTopSuperEntity();

    public List<Entity> getInheritanceChain(Entity var1) throws ModelException;

    public List<Entity> getSubEntities();

    public List<Entity> getAllSubEntities();

    public List<Entity> getLeafEntities();

    public Set<Entity> getAssociatedEntities();

    public Set<List<Relation>> getCompositePaths();

    public Set<List<Relation>> getAllCompositePaths();

    public Set<Entity> getComponents();

    public Set<Entity> getComponentsIncludingInherited();

    public Set<Entity> getAllComponents();

    public boolean isProvidingRootClassIdAccordingToModel();

    public boolean isProvidingRootIdAccordingToModel();

    public boolean isRootEntityAccordingToModel();

    public List<Relation> getDeepReferences();

    public boolean isDeeplyReferenced();

    public List<Relation> getDeepReferencesToComponents();

    public List<Relation> getDeeplyReferencedComponents();
}

