/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityFactory;
import org.tentackle.model.EntityOptions;
import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.TrackType;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.CommonOptionsImpl;

public class EntityOptionsImpl
extends CommonOptionsImpl
implements EntityOptions {
    public static final String OPTION_NO_MODELDEFAULTS = "NODEFAULTS";
    public static final String OPTION_NO_PRIMARY = "NOPKEY";
    public static final String OPTION_TABLESERIAL = "TABLESERIAL";
    public static final String OPTION_TOKENLOCK = "TOKENLOCK";
    public static final String OPTION_NORMTEXT = "NORMTEXT";
    public static final String OPTION_ROOT = "ROOT";
    public static final String OPTION_ROOTID = "ROOTID";
    public static final String OPTION_ROOTCLASSID = "ROOTCLASSID";
    public static final String OPTION_REMOTE = "REMOTE";
    public static final String OPTION_PROVIDED = "PROVIDED";
    public static final String OPTION_CACHED = "CACHED";
    private final EntityFactory factory;
    private final Entity entity;
    private boolean noModelDefaults;
    private boolean noPrimary;
    private TrackType trackType;
    private boolean tableSerialProvided;
    private boolean tokenLockProvided;
    private boolean normTextProvided;
    private boolean rootEntity;
    private boolean rootIdProvided;
    private boolean rootClassIdProvided;
    private boolean remote;
    private boolean provided;
    private boolean cached;
    private List<String> sorting;

    public EntityOptionsImpl(EntityFactory factory, Entity entity, SourceInfo sourceInfo) {
        super(sourceInfo);
        this.factory = factory;
        this.entity = entity;
        this.trackType = TrackType.NONE;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean noModelDefaults() {
        return this.noModelDefaults;
    }

    @Override
    public boolean applyOption(String option, Boolean ctrl) throws ModelException {
        boolean on;
        boolean applied = super.applyOption(option, ctrl);
        boolean bl = on = ctrl == null || ctrl != false;
        if (!applied) {
            String uco = option.toUpperCase();
            applied = true;
            switch (uco) {
                case "NODEFAULTS": {
                    this.setNoModelDefaults(on);
                    break;
                }
                case "NOPKEY": {
                    this.setNoPrimaryKey(on);
                    break;
                }
                case "ROOT": {
                    this.setRootEntity(on);
                    break;
                }
                case "REMOTE": {
                    this.setRemote(on);
                    break;
                }
                case "PROVIDED": {
                    this.setProvided(on);
                    break;
                }
                case "CACHED": {
                    this.setCached(on);
                    break;
                }
                case "TABLESERIAL": {
                    this.setTableSerialProvided(on);
                    break;
                }
                case "ROOTID": {
                    this.setRootIdProvided(on);
                    break;
                }
                case "ROOTCLASSID": {
                    this.setRootClassIdProvided(on);
                    break;
                }
                case "TOKENLOCK": {
                    this.setEditedByProvided(on);
                    break;
                }
                case "NORMTEXT": {
                    this.setNormTextProvided(on);
                    break;
                }
                default: {
                    if (ctrl != null) {
                        if (this.sorting == null) {
                            this.sorting = new ArrayList<String>();
                        }
                        this.sorting.add((on ? "+" : "-") + option);
                        break;
                    }
                    try {
                        this.setTrackType(TrackType.valueOf(uco));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        applied = false;
                    }
                }
            }
        }
        return applied;
    }

    public boolean processSorting(String token) {
        boolean applied = false;
        if (this.sorting == null) {
            this.sorting = new ArrayList<String>();
        }
        if (token != null && !token.isEmpty()) {
            char c = token.charAt(0);
            if (c == '-' || c == '+') {
                this.sorting.add(token);
                applied = true;
            } else if (Character.isLetter(c)) {
                this.sorting.add("+" + token);
                applied = true;
            }
        }
        return applied;
    }

    @Override
    public boolean isNoPrimaryKey() {
        return this.noPrimary;
    }

    @Override
    public TrackType getTrackType() {
        return this.trackType;
    }

    @Override
    public boolean isTableSerialProvided() {
        return this.tableSerialProvided;
    }

    @Override
    public boolean isTokenLockProvided() {
        return this.tokenLockProvided;
    }

    @Override
    public boolean isNormTextProvided() {
        return this.normTextProvided;
    }

    @Override
    public boolean isRoot() {
        return this.rootEntity;
    }

    @Override
    public boolean isRootIdProvided() {
        return this.rootIdProvided;
    }

    @Override
    public boolean isRootClassIdProvided() {
        return this.rootClassIdProvided;
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    @Override
    public boolean isProvided() {
        return this.provided;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public List<String> getSorting() {
        return this.sorting;
    }

    public void setNoModelDefaults(boolean noModelDefaults) {
        this.noModelDefaults = noModelDefaults;
    }

    public void setTrackType(TrackType trackType) {
        this.trackType = trackType;
    }

    public void setEditedByProvided(boolean tokenLockProvided) {
        this.tokenLockProvided = tokenLockProvided;
        AttributeImpl editedByAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("editedBy", false);
        AttributeImpl editedSinceAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("editedSince", false);
        AttributeImpl editedExpiryAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("editedExpiry", false);
        if (tokenLockProvided) {
            if (editedExpiryAttribute == null) {
                editedExpiryAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                editedExpiryAttribute.setDataType(DataType.TIMESTAMP);
                editedExpiryAttribute.setColumnName("editedexpiry");
                editedExpiryAttribute.setName("editedExpiry");
                editedExpiryAttribute.getOptions().setComment("editing lock expiration");
                editedExpiryAttribute.getOptions().setFromSuper(true);
                this.entity.getAttributes().add(0, editedExpiryAttribute);
            }
            if (editedSinceAttribute == null) {
                editedSinceAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                editedSinceAttribute.setDataType(DataType.TIMESTAMP);
                editedSinceAttribute.setColumnName("editedsince");
                editedSinceAttribute.setName("editedSince");
                editedSinceAttribute.getOptions().setComment("being edited since");
                editedSinceAttribute.getOptions().setFromSuper(true);
                this.entity.getAttributes().add(0, editedSinceAttribute);
            }
            if (editedByAttribute == null) {
                editedByAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                editedByAttribute.setDataType(DataType.LONG_PRIMITIVE);
                editedByAttribute.setColumnName("editedby");
                editedByAttribute.setName("editedBy");
                editedByAttribute.getOptions().setComment("being edited by user id");
                editedByAttribute.getOptions().setFromSuper(true);
                editedByAttribute.getOptions().setDefaultValue(0L);
                this.entity.getAttributes().add(0, editedByAttribute);
            }
        } else {
            if (editedByAttribute != null) {
                this.entity.getAttributes().remove(editedByAttribute);
            }
            if (editedSinceAttribute != null) {
                this.entity.getAttributes().remove(editedSinceAttribute);
            }
            if (editedExpiryAttribute != null) {
                this.entity.getAttributes().remove(editedExpiryAttribute);
            }
        }
    }

    public void setNormTextProvided(boolean normText) {
        this.normTextProvided = normText;
        AttributeImpl normTextAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("normText", false);
        if (normText) {
            if (normTextAttribute == null) {
                normTextAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                normTextAttribute.setDataType(DataType.STRING);
                normTextAttribute.setColumnName("normtext");
                normTextAttribute.setName("normText");
                normTextAttribute.getOptions().setComment("normalized text");
                normTextAttribute.getOptions().setFromSuper(true);
                this.entity.getAttributes().add(0, normTextAttribute);
            }
        } else if (normTextAttribute != null) {
            this.entity.getAttributes().remove(normTextAttribute);
        }
    }

    public void setNoPrimaryKey(boolean noPrimary) {
        this.noPrimary = noPrimary;
    }

    public void setTableSerialProvided(boolean tableSerial) {
        this.tableSerialProvided = tableSerial;
        AttributeImpl tableSerialAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("tableSerial", false);
        if (tableSerial) {
            if (tableSerialAttribute == null) {
                tableSerialAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                tableSerialAttribute.setDataType(DataType.LONG_PRIMITIVE);
                tableSerialAttribute.setColumnName("tableserial");
                tableSerialAttribute.setName("tableSerial");
                tableSerialAttribute.getOptions().setComment("table serial");
                tableSerialAttribute.getOptions().setFromSuper(true);
                this.entity.getAttributes().add(0, tableSerialAttribute);
            }
        } else if (tableSerialAttribute != null) {
            this.entity.getAttributes().remove(tableSerialAttribute);
        }
    }

    public void setRootEntity(boolean rootEntity) {
        this.rootEntity = rootEntity;
    }

    public void setRootIdProvided(boolean rootId) {
        this.rootIdProvided = rootId;
        AttributeImpl rootIdAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("rootId", false);
        if (rootId) {
            if (rootIdAttribute == null) {
                rootIdAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                rootIdAttribute.setDataType(DataType.LONG_PRIMITIVE);
                rootIdAttribute.setColumnName("rootid");
                rootIdAttribute.setName("rootId");
                rootIdAttribute.getOptions().setComment("root entity id");
                rootIdAttribute.getOptions().setFromSuper(true);
                this.entity.getAttributes().add(0, rootIdAttribute);
            }
        } else if (rootIdAttribute != null) {
            this.entity.getAttributes().remove(rootIdAttribute);
        }
    }

    public void setRootClassIdProvided(boolean rootClassId) {
        this.rootClassIdProvided = rootClassId;
        AttributeImpl rootClassIdAttribute = (AttributeImpl)this.entity.getAttributeByJavaName("rootClassId", false);
        if (rootClassId) {
            if (rootClassIdAttribute == null) {
                rootClassIdAttribute = (AttributeImpl)this.factory.createAttribute(this.entity, this.getSourceInfo(), true);
                rootClassIdAttribute.setDataType(DataType.INTEGER_PRIMITIVE);
                rootClassIdAttribute.setColumnName("rootclassid");
                rootClassIdAttribute.setName("rootClassId");
                rootClassIdAttribute.getOptions().setComment("root entity class id");
                rootClassIdAttribute.getOptions().setFromSuper(true);
                this.entity.getAttributes().add(0, rootClassIdAttribute);
            }
        } else if (rootClassIdAttribute != null) {
            this.entity.getAttributes().remove(rootClassIdAttribute);
        }
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setProvided(boolean provided) {
        this.provided = provided;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }
}

