/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;
import org.tentackle.model.impl.ModelDirectory;

public class ModelDirectoryImpl
implements ModelDirectory {
    private final File dir;
    private final String path;
    private final ModelDefaults modelDefaults;
    private final EntityAliases entityAliases;
    private long lastModified;

    public ModelDirectoryImpl(String modelDir, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        this.dir = new File(modelDir);
        if (!this.dir.exists()) {
            throw new ModelException(modelDir + " does not exist");
        }
        if (!this.dir.isDirectory()) {
            throw new ModelException(modelDir + " is not a directory");
        }
        try {
            this.path = this.dir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ModelException("cannot determine path of model directory " + this.dir, e);
        }
        this.lastModified = this.dir.lastModified();
        this.modelDefaults = defaults;
        this.entityAliases = aliases;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<String> getFilePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        File[] files = this.dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || file.isHidden()) continue;
                paths.add(new File(this.path, file.getName()).getAbsolutePath());
            }
        }
        return paths;
    }

    @Override
    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    @Override
    public EntityAliases getEntityAliases() {
        return this.entityAliases;
    }

    @Override
    public boolean hasChanged() {
        return this.dir.lastModified() > this.lastModified;
    }

    @Override
    public void markDirty() {
        this.lastModified = 0L;
    }
}

