/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.model.migrate.ColumnMigration;
import org.tentackle.model.migrate.ColumnMigrator;
import org.tentackle.model.migrate.ForeignKeyMigrator;
import org.tentackle.model.migrate.IndexMigrator;
import org.tentackle.sql.Backend;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyAction;
import org.tentackle.sql.metadata.ForeignKeyColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.TableMetaData;

public class TableMigrator {
    private final Entity entity;
    private final Collection<ForeignKey> foreignKeys;
    private final Backend backend;
    private final TableMetaData table;

    public TableMigrator(Entity entity, Collection<ForeignKey> foreignKeys, Backend backend, TableMetaData table) {
        this.entity = entity;
        this.foreignKeys = foreignKeys;
        this.backend = backend;
        this.table = table;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public TableMetaData getTable() {
        return this.table;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.entity.getName());
        buf.append(" -> ");
        if (this.table == null) {
            buf.append("table missing");
        } else {
            buf.append(this.table.getFullTableName());
        }
        return buf.toString();
    }

    public Result migrate(Collection<Pattern> hints, Collection<ColumnMigration> columnMigrations, Map<String, String> renameColumns) throws ModelException {
        StringBuilder tableSql = new StringBuilder();
        StringBuilder foreignKeySql = new StringBuilder();
        StringBuilder warningSql = new StringBuilder();
        if (this.table == null) {
            tableSql.append(this.createTable());
            foreignKeySql.append(this.createForeignKeys());
        } else {
            IndexMigrator.Result indexResult = this.migrateIndexes();
            tableSql.append(indexResult.getDropSql());
            Result columnResult = this.migrateColumns(hints, columnMigrations, renameColumns);
            tableSql.append(columnResult.getTableSql());
            warningSql.append(columnResult.getWarningSql());
            tableSql.append(this.migrateTable());
            tableSql.append(indexResult.getCreateSql());
            foreignKeySql.append(this.migrateForeignKeys());
        }
        if (tableSql.length() > 0) {
            tableSql.insert(0, '\n');
        }
        return new Result(tableSql.toString(), foreignKeySql.toString(), warningSql.toString());
    }

    private String createTable() throws ModelException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.entity.sqlCreateTable(this.backend));
        for (Index index : this.entity.getTableIndexes()) {
            buf.append(index.sqlCreateIndex(this.backend, this.entity));
        }
        return buf.toString();
    }

    private String createForeignKeys() {
        StringBuilder buf = new StringBuilder();
        for (ForeignKey foreignKey : this.foreignKeys) {
            buf.append(foreignKey.sqlCreateForeignKey(this.backend));
        }
        return buf.toString();
    }

    private ColumnMigration getColumnMigrationForColumn(String columName, Collection<ColumnMigration> columnMigrations) {
        if (columnMigrations != null && columName != null) {
            for (ColumnMigration migration : columnMigrations) {
                if (!StringHelper.equalsIgnoreCase((String)columName, (String)migration.getColumnName())) continue;
                return migration;
            }
        }
        return null;
    }

    private ColumnMigration getColumnMigrationForNewColumn(String newColumName, Collection<ColumnMigration> columnMigrations) {
        if (columnMigrations != null && newColumName != null) {
            for (ColumnMigration migration : columnMigrations) {
                if (!StringHelper.equalsIgnoreCase((String)newColumName, (String)migration.getNewColumnName())) continue;
                return migration;
            }
        }
        return null;
    }

    private String migrateTable() {
        String sql;
        if (!Objects.equals(this.table.getComment(), this.entity.getOptions().getComment()) && (sql = this.backend.sqlAlterTableComment(this.entity.getTableName(), this.entity.getOptions().getComment())) != null && !sql.isEmpty()) {
            return sql;
        }
        return "";
    }

    private Result migrateColumns(Collection<Pattern> hints, Collection<ColumnMigration> columnMigrations, Map<String, String> renameColumns) throws ModelException {
        StringBuilder sqlBuf = new StringBuilder();
        StringBuilder warnBuf = new StringBuilder();
        HashMap<String, ColumnMetaData> columnsToDrop = new HashMap<String, ColumnMetaData>();
        HashSet<Attribute> attributesToAdd = new HashSet<Attribute>();
        HashMap attributesToMigrate = new HashMap();
        for (ColumnMetaData columnMetaData : this.table.getColumns()) {
            columnsToDrop.put(columnMetaData.getColumnName(), columnMetaData);
        }
        for (Attribute attribute : this.entity.getTableAttributes()) {
            ArrayList<ColumnMetaData> matchingColumns = new ArrayList<ColumnMetaData>();
            for (DataType.SqlTypeWithPostfix sp : attribute.getDataType().getSqlTypesWithPostfix()) {
                ColumnMetaData column = this.table.getColumnByName(attribute.getColumnName() + sp.getPostfix());
                if (column == null) continue;
                matchingColumns.add(column);
            }
            if (matchingColumns.isEmpty()) {
                ColumnMetaData oldColumn;
                Object oldColumnName = null;
                if (renameColumns != null && (oldColumnName = renameColumns.get(attribute.getColumnName())) != null && (oldColumn = (ColumnMetaData)columnsToDrop.get(oldColumnName)) != null) {
                    columnsToDrop.remove(oldColumnName);
                    for (DataType.SqlTypeWithPostfix sp : attribute.getDataType().getSqlTypesWithPostfix()) {
                        ColumnMetaData column = this.table.getColumnByName((String)oldColumnName + sp.getPostfix());
                        if (column == null) continue;
                        matchingColumns.add(column);
                    }
                    if (!matchingColumns.isEmpty()) {
                        attributesToMigrate.put(attribute, matchingColumns);
                        continue;
                    }
                }
                attributesToAdd.add(attribute);
                continue;
            }
            for (ColumnMetaData matchingColumn : matchingColumns) {
                columnsToDrop.remove(matchingColumn.getColumnName());
            }
            attributesToMigrate.put(attribute, matchingColumns);
        }
        Iterator<Object> addAttributeIterator = attributesToAdd.iterator();
        while (addAttributeIterator.hasNext()) {
            Attribute attribute = (Attribute)addAttributeIterator.next();
            String addSql = new ColumnMigrator(this.entity, attribute, this.backend, new ColumnMetaData[0]).migrate();
            Pattern addHint = this.sqlMatchesHint(addSql, hints);
            DataType.SqlTypeWithPostfix[] typeMatchingColumn = null;
            for (DataType.SqlTypeWithPostfix[] dropColumn : columnsToDrop.values()) {
                if (!dropColumn.matchesSqlType(attribute.getDataType().getSqlTypes()[0])) continue;
                if (typeMatchingColumn == null) {
                    typeMatchingColumn = dropColumn;
                    continue;
                }
                typeMatchingColumn = null;
                break;
            }
            ArrayList<ColumnMetaData> matchingColumns = new ArrayList<ColumnMetaData>();
            if (typeMatchingColumn != null) {
                for (DataType.SqlTypeWithPostfix sp : attribute.getDataType().getSqlTypesWithPostfix()) {
                    String columnName = typeMatchingColumn.getColumnName() + sp.getPostfix();
                    ColumnMetaData dropColumn = (ColumnMetaData)columnsToDrop.get(columnName);
                    if (dropColumn == null) continue;
                    matchingColumns.add(dropColumn);
                }
            }
            if (matchingColumns.size() != attribute.getDataType().getSqlTypes().length) continue;
            String renameSql = new ColumnMigrator(this.entity, attribute, this.backend, matchingColumns).migrate();
            Pattern renameHint = this.sqlMatchesHint(renameSql, hints);
            String dropSql = new ColumnMigrator(this.entity, null, this.backend, matchingColumns).migrate();
            Pattern dropHint = this.sqlMatchesHint(dropSql, hints);
            if (renameHint != null) {
                if (addHint != null) {
                    throw new ModelException("migration hints collision:\n'" + addHint + "' applies to '" + (String)addSql + "'\n'" + renameHint + "' applies to '" + renameSql + "'\n-> fix hints!");
                }
                if (dropHint != null) {
                    throw new ModelException("migration hints collision:\n'" + dropHint + "' applies to '" + dropSql + "'\n'" + renameHint + "' applies to '" + renameSql + "'\n-> fix hints!");
                }
            } else {
                if (addHint != null || dropHint != null) {
                    sqlBuf.append(this.backend.sqlComment(renameSql));
                    sqlBuf.append("-- disabled by hint '");
                    if (addHint != null) {
                        sqlBuf.append(addHint);
                    }
                    if (dropHint != null) {
                        sqlBuf.append(dropHint);
                    }
                    sqlBuf.append("'\n");
                    continue;
                }
                sqlBuf.append(this.backend.sqlComment(addSql));
                sqlBuf.append(this.backend.sqlComment(dropSql));
            }
            addAttributeIterator.remove();
            for (ColumnMetaData dropColumn : matchingColumns) {
                columnsToDrop.remove(dropColumn.getColumnName());
            }
            attributesToMigrate.put(attribute, matchingColumns);
        }
        if (!columnsToDrop.isEmpty() && hints != null && !hints.isEmpty()) {
            addAttributeIterator = attributesToAdd.iterator();
            block9: while (addAttributeIterator.hasNext()) {
                Attribute attribute = (Attribute)addAttributeIterator.next();
                for (ColumnMetaData dropColumn : new ArrayList(columnsToDrop.values())) {
                    String renameSql;
                    Pattern renameHint;
                    ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
                    for (DataType.SqlTypeWithPostfix sp : attribute.getDataType().getSqlTypesWithPostfix()) {
                        String columnName = dropColumn.getColumnName() + sp.getPostfix();
                        ColumnMetaData column = (ColumnMetaData)columnsToDrop.get(columnName);
                        if (column == null) continue;
                        columns.add(column);
                    }
                    if (columns.size() != attribute.getDataType().getSqlTypes().length || (renameHint = this.sqlMatchesHint(renameSql = new ColumnMigrator(this.entity, attribute, this.backend, columns).migrate(), hints)) == null) continue;
                    addAttributeIterator.remove();
                    for (ColumnMetaData column : columns) {
                        columnsToDrop.remove(column.getColumnName());
                    }
                    attributesToMigrate.put(attribute, columns);
                    continue block9;
                }
            }
        }
        for (ColumnMetaData columnMetaData : columnsToDrop.values()) {
            if (this.getColumnMigrationForColumn(columnMetaData.getColumnName(), columnMigrations) != null) continue;
            sqlBuf.append(new ColumnMigrator(this.entity, null, this.backend, columnMetaData).migrate());
        }
        for (Attribute attribute : attributesToAdd) {
            if (this.getColumnMigrationForNewColumn(attribute.getColumnName(), columnMigrations) != null) continue;
            sqlBuf.append(new ColumnMigrator(this.entity, attribute, this.backend, new ColumnMetaData[0]).migrate());
        }
        for (Map.Entry entry : attributesToMigrate.entrySet()) {
            String columnName = ((ColumnMetaData)((Collection)entry.getValue()).iterator().next()).getColumnName();
            ColumnMigration explicitMigration = this.getColumnMigrationForColumn(columnName, columnMigrations);
            String migrationCode = new ColumnMigrator(this.entity, (Attribute)entry.getKey(), this.backend, (Collection)entry.getValue()).migrate();
            if (migrationCode.isEmpty()) {
                if (explicitMigration == null) continue;
                columnMigrations.remove(explicitMigration);
                continue;
            }
            if (migrationCode.startsWith("-- ")) {
                warnBuf.append(migrationCode);
                continue;
            }
            if (explicitMigration == null) {
                sqlBuf.append(migrationCode);
                continue;
            }
            sqlBuf.append(this.backend.sqlComment(migrationCode));
        }
        if (sqlBuf.length() > 0 && columnMigrations != null) {
            for (ColumnMigration columnMigration : columnMigrations) {
                sqlBuf.append(columnMigration.getSql());
                sqlBuf.append('\n');
            }
        }
        if (sqlBuf.length() > 0 && hints != null && !hints.isEmpty()) {
            StringBuilder hintsBuf = new StringBuilder();
            hintsBuf.append("-- hints for ");
            hintsBuf.append(this.entity);
            hintsBuf.append('\n');
            for (Pattern hint : hints) {
                hintsBuf.append("-- ");
                hintsBuf.append(hint);
                hintsBuf.append('\n');
            }
            sqlBuf.insert(0, hintsBuf);
        }
        return new Result(sqlBuf.toString(), "", warnBuf.toString());
    }

    private Pattern sqlMatchesHint(String sql, Collection<Pattern> hints) {
        Pattern matchingHint = null;
        if (hints != null) {
            for (Pattern hint : hints) {
                if (!hint.matcher(sql).matches()) continue;
                matchingHint = hint;
                break;
            }
        }
        return matchingHint;
    }

    private IndexMigrator.Result migrateIndexes() {
        boolean found;
        IndexMigrator.Result result = new IndexMigrator.Result("", "");
        Collection existingIndexes = this.table.getIndexes();
        List<Index> tableIndexes = this.entity.getTableIndexes();
        ArrayList<IndexMetaData> renamedIndexes = new ArrayList<IndexMetaData>();
        for (Index index : tableIndexes) {
            found = false;
            for (IndexMetaData existingIndex : existingIndexes) {
                String existingName;
                String indexName = index.createDatabaseIndexName(this.entity);
                if (existingIndex.getIndexName().equalsIgnoreCase(indexName)) {
                    result = result.sum(new IndexMigrator(this.entity, index, this.backend, existingIndex).migrate());
                    found = true;
                    break;
                }
                if (IndexMigrator.isLogicallyDifferent(index, existingIndex, null)) continue;
                int count = 0;
                for (IndexMetaData exNdx : existingIndexes) {
                    if (IndexMigrator.isLogicallyDifferent(index, exNdx, null)) continue;
                    ++count;
                }
                if (count != true) continue;
                String string = existingName = this.entity.getSchemaName() == null || Model.getInstance().isSchemaNameMapped() ? existingIndex.getIndexName() : this.entity.getSchemaName() + "." + existingIndex.getIndexName();
                String sql = this.backend.sqlRenameIndex(this.entity.getTableName(), existingName, indexName);
                if (sql == null) continue;
                result = result.sum(new IndexMigrator.Result(sql, ""));
                found = true;
                renamedIndexes.add(existingIndex);
                break;
            }
            if (found) continue;
            result = result.sum(new IndexMigrator(this.entity, index, this.backend, null).migrate());
        }
        for (IndexMetaData existingIndex : existingIndexes) {
            if (existingIndex.isPrimaryIdKey() || renamedIndexes.contains(existingIndex)) continue;
            found = false;
            for (Index index : tableIndexes) {
                if (!index.createDatabaseIndexName(this.entity).equalsIgnoreCase(existingIndex.getIndexName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result = result.sum(new IndexMigrator(this.entity, null, this.backend, existingIndex).migrate());
        }
        return result;
    }

    private String migrateForeignKeys() throws ModelException {
        boolean found;
        StringBuilder buf = new StringBuilder();
        Collection existingForeignKeys = this.table.getForeignKeys();
        for (ForeignKeyMetaData existingForeignKey : existingForeignKeys) {
            found = false;
            for (ForeignKey foreignKey : this.foreignKeys) {
                if (!this.foreignKeysMatch(foreignKey, existingForeignKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            buf.append(new ForeignKeyMigrator(this.backend, null, existingForeignKey).migrate());
        }
        for (ForeignKey foreignKey : this.foreignKeys) {
            found = false;
            for (ForeignKeyMetaData existingForeignKey : existingForeignKeys) {
                if (!this.foreignKeysMatch(foreignKey, existingForeignKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            buf.append(new ForeignKeyMigrator(this.backend, foreignKey, null).migrate());
        }
        return buf.toString();
    }

    private boolean foreignKeysMatch(ForeignKey foreignKey, ForeignKeyMetaData existingForeignKey) {
        Entity referencingTableProvidingEntity = foreignKey.getReferencingTableProvidingEntity();
        Entity referencedTableProvidingEntity = foreignKey.getReferencedTableProvidingEntity();
        boolean mapSchemas = Model.getInstance().isSchemaNameMapped();
        return !(existingForeignKey.getForeignKeyColumns().size() != 1 || existingForeignKey.getDeleteRule() == ForeignKeyAction.CASCADE != foreignKey.isComposite() || !foreignKey.getReferencingAttribute().getColumnName().equalsIgnoreCase(((ForeignKeyColumnMetaData)existingForeignKey.getForeignKeyColumns().get(0)).getForeignKeyColumn()) || !mapSchemas && !StringHelper.equalsIgnoreCase((String)referencingTableProvidingEntity.getSchemaName(), (String)existingForeignKey.getForeignKeySchema()) || !referencingTableProvidingEntity.getTableNameWithoutSchema().equalsIgnoreCase(existingForeignKey.getForeignKeyTable()) || !foreignKey.getReferencedAttribute().getColumnName().equalsIgnoreCase(((ForeignKeyColumnMetaData)existingForeignKey.getForeignKeyColumns().get(0)).getPrimaryKeyColumn()) || !mapSchemas && !StringHelper.equalsIgnoreCase((String)referencedTableProvidingEntity.getSchemaName(), (String)existingForeignKey.getPrimaryKeySchema()) || !referencedTableProvidingEntity.getTableNameWithoutSchema().equalsIgnoreCase(existingForeignKey.getPrimaryKeyTable()));
    }

    public static class Result {
        private final String tableSql;
        private final String foreignKeySql;
        private final String warningSql;

        public Result(String tableSql, String foreignKeySql, String warningSql) {
            this.tableSql = tableSql;
            this.foreignKeySql = foreignKeySql;
            this.warningSql = warningSql;
        }

        public String getTableSql() {
            return this.tableSql;
        }

        public String getForeignKeySql() {
            return this.foreignKeySql;
        }

        public String getWarningSql() {
            return this.warningSql;
        }
    }
}

